// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

/**
 * The key verify parameters.
 */
@Fluent
public final class KeyVerifyParameters implements JsonSerializable<KeyVerifyParameters> {
    /*
     * The signing/verification algorithm. For more information on possible algorithm types, see
     * JsonWebKeySignatureAlgorithm.
     */
    private JsonWebKeySignatureAlgorithm algorithm;

    /*
     * The digest used for signing.
     */
    private Base64Url digest;

    /*
     * The signature to be verified.
     */
    private Base64Url signature;

    /**
     * Creates an instance of KeyVerifyParameters class.
     */
    public KeyVerifyParameters() {
    }

    /**
     * Get the algorithm property: The signing/verification algorithm. For more information on possible algorithm types,
     * see JsonWebKeySignatureAlgorithm.
     * 
     * @return the algorithm value.
     */
    public JsonWebKeySignatureAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    /**
     * Set the algorithm property: The signing/verification algorithm. For more information on possible algorithm types,
     * see JsonWebKeySignatureAlgorithm.
     * 
     * @param algorithm the algorithm value to set.
     * @return the KeyVerifyParameters object itself.
     */
    public KeyVerifyParameters setAlgorithm(JsonWebKeySignatureAlgorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    /**
     * Get the digest property: The digest used for signing.
     * 
     * @return the digest value.
     */
    public byte[] getDigest() {
        if (this.digest == null) {
            return null;
        }
        return this.digest.decodedBytes();
    }

    /**
     * Set the digest property: The digest used for signing.
     * 
     * @param digest the digest value to set.
     * @return the KeyVerifyParameters object itself.
     */
    public KeyVerifyParameters setDigest(byte[] digest) {
        if (digest == null) {
            this.digest = null;
        } else {
            this.digest = Base64Url.encode(CoreUtils.clone(digest));
        }
        return this;
    }

    /**
     * Get the signature property: The signature to be verified.
     * 
     * @return the signature value.
     */
    public byte[] getSignature() {
        if (this.signature == null) {
            return null;
        }
        return this.signature.decodedBytes();
    }

    /**
     * Set the signature property: The signature to be verified.
     * 
     * @param signature the signature value to set.
     * @return the KeyVerifyParameters object itself.
     */
    public KeyVerifyParameters setSignature(byte[] signature) {
        if (signature == null) {
            this.signature = null;
        } else {
            this.signature = Base64Url.encode(CoreUtils.clone(signature));
        }
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("alg", this.algorithm == null ? null : this.algorithm.toString());
        jsonWriter.writeStringField("digest", Objects.toString(this.digest, null));
        jsonWriter.writeStringField("value", Objects.toString(this.signature, null));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyVerifyParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyVerifyParameters if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KeyVerifyParameters.
     */
    public static KeyVerifyParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyVerifyParameters deserializedKeyVerifyParameters = new KeyVerifyParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("alg".equals(fieldName)) {
                    deserializedKeyVerifyParameters.algorithm
                        = JsonWebKeySignatureAlgorithm.fromString(reader.getString());
                } else if ("digest".equals(fieldName)) {
                    deserializedKeyVerifyParameters.digest
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else if ("value".equals(fieldName)) {
                    deserializedKeyVerifyParameters.signature
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyVerifyParameters;
        });
    }
}
