/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.keys.models.KeyCurveName;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyType;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public final class JsonWebKey
implements JsonSerializable<JsonWebKey> {
    private String kid;
    private KeyType kty;
    private List<KeyOperation> keyOps;
    private Base64Url n;
    private Base64Url e;
    private Base64Url d;
    private Base64Url dp;
    private Base64Url dq;
    private Base64Url qi;
    private Base64Url p;
    private Base64Url q;
    private Base64Url k;
    private Base64Url t;
    private KeyCurveName crv;
    private Base64Url x;
    private Base64Url y;

    public String getKid() {
        return this.kid;
    }

    public JsonWebKey setKid(String kid) {
        this.kid = kid;
        return this;
    }

    public KeyType getKty() {
        return this.kty;
    }

    public JsonWebKey setKty(KeyType kty) {
        this.kty = kty;
        return this;
    }

    public List<KeyOperation> getKeyOps() {
        return this.keyOps;
    }

    public JsonWebKey setKeyOps(List<KeyOperation> keyOps) {
        this.keyOps = keyOps;
        return this;
    }

    public byte[] getN() {
        if (this.n == null) {
            return null;
        }
        return this.n.decodedBytes();
    }

    public JsonWebKey setN(byte[] n) {
        this.n = n == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])n));
        return this;
    }

    public byte[] getE() {
        if (this.e == null) {
            return null;
        }
        return this.e.decodedBytes();
    }

    public JsonWebKey setE(byte[] e) {
        this.e = e == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])e));
        return this;
    }

    public byte[] getD() {
        if (this.d == null) {
            return null;
        }
        return this.d.decodedBytes();
    }

    public JsonWebKey setD(byte[] d) {
        this.d = d == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])d));
        return this;
    }

    public byte[] getDp() {
        if (this.dp == null) {
            return null;
        }
        return this.dp.decodedBytes();
    }

    public JsonWebKey setDp(byte[] dp) {
        this.dp = dp == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])dp));
        return this;
    }

    public byte[] getDq() {
        if (this.dq == null) {
            return null;
        }
        return this.dq.decodedBytes();
    }

    public JsonWebKey setDq(byte[] dq) {
        this.dq = dq == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])dq));
        return this;
    }

    public byte[] getQi() {
        if (this.qi == null) {
            return null;
        }
        return this.qi.decodedBytes();
    }

    public JsonWebKey setQi(byte[] qi) {
        this.qi = qi == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])qi));
        return this;
    }

    public byte[] getP() {
        if (this.p == null) {
            return null;
        }
        return this.p.decodedBytes();
    }

    public JsonWebKey setP(byte[] p) {
        this.p = p == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])p));
        return this;
    }

    public byte[] getQ() {
        if (this.q == null) {
            return null;
        }
        return this.q.decodedBytes();
    }

    public JsonWebKey setQ(byte[] q) {
        this.q = q == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])q));
        return this;
    }

    public byte[] getK() {
        if (this.k == null) {
            return null;
        }
        return this.k.decodedBytes();
    }

    public JsonWebKey setK(byte[] k) {
        this.k = k == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])k));
        return this;
    }

    public byte[] getT() {
        if (this.t == null) {
            return null;
        }
        return this.t.decodedBytes();
    }

    public JsonWebKey setT(byte[] t) {
        this.t = t == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])t));
        return this;
    }

    public KeyCurveName getCrv() {
        return this.crv;
    }

    public JsonWebKey setCrv(KeyCurveName crv) {
        this.crv = crv;
        return this;
    }

    public byte[] getX() {
        if (this.x == null) {
            return null;
        }
        return this.x.decodedBytes();
    }

    public JsonWebKey setX(byte[] x) {
        this.x = x == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])x));
        return this;
    }

    public byte[] getY() {
        if (this.y == null) {
            return null;
        }
        return this.y.decodedBytes();
    }

    public JsonWebKey setY(byte[] y) {
        this.y = y == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])y));
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kid", this.kid);
        jsonWriter.writeStringField("kty", this.kty == null ? null : this.kty.toString());
        jsonWriter.writeArrayField("key_ops", this.keyOps, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("n", Objects.toString(this.n, null));
        jsonWriter.writeStringField("e", Objects.toString(this.e, null));
        jsonWriter.writeStringField("d", Objects.toString(this.d, null));
        jsonWriter.writeStringField("dp", Objects.toString(this.dp, null));
        jsonWriter.writeStringField("dq", Objects.toString(this.dq, null));
        jsonWriter.writeStringField("qi", Objects.toString(this.qi, null));
        jsonWriter.writeStringField("p", Objects.toString(this.p, null));
        jsonWriter.writeStringField("q", Objects.toString(this.q, null));
        jsonWriter.writeStringField("k", Objects.toString(this.k, null));
        jsonWriter.writeStringField("key_hsm", Objects.toString(this.t, null));
        jsonWriter.writeStringField("crv", this.crv == null ? null : this.crv.toString());
        jsonWriter.writeStringField("x", Objects.toString(this.x, null));
        jsonWriter.writeStringField("y", Objects.toString(this.y, null));
        return jsonWriter.writeEndObject();
    }

    public static JsonWebKey fromJson(JsonReader jsonReader) throws IOException {
        return (JsonWebKey)jsonReader.readObject(reader -> {
            JsonWebKey deserializedJsonWebKey = new JsonWebKey();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kid".equals(fieldName)) {
                    deserializedJsonWebKey.kid = reader.getString();
                    continue;
                }
                if ("kty".equals(fieldName)) {
                    deserializedJsonWebKey.kty = KeyType.fromString(reader.getString());
                    continue;
                }
                if ("key_ops".equals(fieldName)) {
                    List keyOps;
                    deserializedJsonWebKey.keyOps = keyOps = reader.readArray(reader1 -> KeyOperation.fromString(reader1.getString()));
                    continue;
                }
                if ("n".equals(fieldName)) {
                    deserializedJsonWebKey.n = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("e".equals(fieldName)) {
                    deserializedJsonWebKey.e = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("d".equals(fieldName)) {
                    deserializedJsonWebKey.d = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("dp".equals(fieldName)) {
                    deserializedJsonWebKey.dp = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("dq".equals(fieldName)) {
                    deserializedJsonWebKey.dq = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("qi".equals(fieldName)) {
                    deserializedJsonWebKey.qi = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("p".equals(fieldName)) {
                    deserializedJsonWebKey.p = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("q".equals(fieldName)) {
                    deserializedJsonWebKey.q = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("k".equals(fieldName)) {
                    deserializedJsonWebKey.k = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("key_hsm".equals(fieldName)) {
                    deserializedJsonWebKey.t = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("crv".equals(fieldName)) {
                    deserializedJsonWebKey.crv = KeyCurveName.fromString(reader.getString());
                    continue;
                }
                if ("x".equals(fieldName)) {
                    deserializedJsonWebKey.x = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("y".equals(fieldName)) {
                    deserializedJsonWebKey.y = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJsonWebKey;
        });
    }
}

