// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.keys.models.KeyRotationPolicyAction;
import java.io.IOException;

/**
 * The action that will be executed.
 */
@Fluent
public final class LifetimeActionsType implements JsonSerializable<LifetimeActionsType> {
    /*
     * The type of the action. The value should be compared case-insensitively.
     */
    private KeyRotationPolicyAction type;

    /**
     * Creates an instance of LifetimeActionsType class.
     */
    public LifetimeActionsType() {
    }

    /**
     * Get the type property: The type of the action. The value should be compared case-insensitively.
     * 
     * @return the type value.
     */
    public KeyRotationPolicyAction getType() {
        return this.type;
    }

    /**
     * Set the type property: The type of the action. The value should be compared case-insensitively.
     * 
     * @param type the type value to set.
     * @return the LifetimeActionsType object itself.
     */
    public LifetimeActionsType setType(KeyRotationPolicyAction type) {
        this.type = type;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LifetimeActionsType from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LifetimeActionsType if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the LifetimeActionsType.
     */
    public static LifetimeActionsType fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LifetimeActionsType deserializedLifetimeActionsType = new LifetimeActionsType();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedLifetimeActionsType.type = KeyRotationPolicyAction.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLifetimeActionsType;
        });
    }
}
