/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnValueWireType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.security.keyvault.secrets.SecretBackup;
import com.azure.security.keyvault.secrets.SecretRequestParameters;
import com.azure.security.keyvault.secrets.SecretRestoreRequestParameters;
import com.azure.security.keyvault.secrets.implementation.DeletedSecretPage;
import com.azure.security.keyvault.secrets.implementation.SecretPropertiesPage;
import com.azure.security.keyvault.secrets.models.DeletedSecret;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.azure.security.keyvault.secrets.models.SecretProperties;
import reactor.core.publisher.Mono;

@Host(value="{url}")
@ServiceInterface(name="KeyVaultSecrets")
interface SecretService {
    @Put(value="secrets/{secret-name}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<KeyVaultSecret>> setSecret(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @BodyParam(value="body") SecretRequestParameters var5, @HeaderParam(value="Content-Type") String var6, Context var7);

    @Get(value="secrets/{secret-name}/{secret-version}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(code={403}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<KeyVaultSecret>> getSecret(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @PathParam(value="secret-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

    @Get(value="secrets/{secret-name}/{secret-version}")
    @ExpectedResponses(value={200, 404})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={403}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<KeyVaultSecret>> getSecretPoller(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @PathParam(value="secret-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

    @Patch(value="secrets/{secret-name}/{secret-version}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    public Mono<Response<SecretProperties>> updateSecret(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @PathParam(value="secret-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @BodyParam(value="body") SecretRequestParameters var6, @HeaderParam(value="Content-Type") String var7, Context var8);

    @Delete(value="secrets/{secret-name}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<DeletedSecret>> deleteSecret(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Get(value="deletedsecrets/{secret-name}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<DeletedSecret>> getDeletedSecret(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Get(value="deletedsecrets/{secret-name}")
    @ExpectedResponses(value={200, 404})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    public Mono<Response<DeletedSecret>> getDeletedSecretPoller(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Delete(value="deletedsecrets/{secret-name}")
    @ExpectedResponses(value={204})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<Void>> purgeDeletedSecret(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Post(value="deletedsecrets/{secret-name}/recover")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<KeyVaultSecret>> recoverDeletedSecret(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Post(value="secrets/{secret-name}/backup")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<SecretBackup>> backupSecret(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Post(value="secrets/restore")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<KeyVaultSecret>> restoreSecret(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept-language") String var3, @BodyParam(value="application/json") SecretRestoreRequestParameters var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Get(value="secrets")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    @ReturnValueWireType(value=SecretPropertiesPage.class)
    public Mono<PagedResponse<SecretProperties>> getSecrets(@HostParam(value="url") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Get(value="secrets/{secret-name}/versions")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    @ReturnValueWireType(value=SecretPropertiesPage.class)
    public Mono<PagedResponse<SecretProperties>> getSecretVersions(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="maxresults") Integer var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

    @Get(value="{nextUrl}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    @ReturnValueWireType(value=SecretPropertiesPage.class)
    public Mono<PagedResponse<SecretProperties>> getSecrets(@HostParam(value="url") String var1, @PathParam(value="nextUrl", encoded=true) String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Content-Type") String var4, Context var5);

    @Get(value="deletedsecrets")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    @ReturnValueWireType(value=DeletedSecretPage.class)
    public Mono<PagedResponse<DeletedSecret>> getDeletedSecrets(@HostParam(value="url") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

    @Get(value="{nextUrl}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    @ReturnValueWireType(value=DeletedSecretPage.class)
    public Mono<PagedResponse<DeletedSecret>> getDeletedSecrets(@HostParam(value="url") String var1, @PathParam(value="nextUrl", encoded=true) String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Content-Type") String var4, Context var5);
}

