// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.security.keyvault.secrets.implementation.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * A secret consisting of a value, id and its attributes.
 */
@Immutable
public final class SecretBundle implements JsonSerializable<SecretBundle> {
    /*
     * The secret value.
     */
    @Generated
    private String value;

    /*
     * The secret id.
     */
    @Generated
    private String id;

    /*
     * The content type of the secret.
     */
    @Generated
    private String contentType;

    /*
     * The secret management attributes.
     */
    @Generated
    private SecretAttributes attributes;

    /*
     * Application specific metadata in the form of key-value pairs.
     */
    @Generated
    private Map<String, String> tags;

    /*
     * If this is a secret backing a KV certificate, then this field specifies the corresponding key backing the KV
     * certificate.
     */
    @Generated
    private String kid;

    /*
     * True if the secret's lifetime is managed by key vault. If this is a secret backing a certificate, then managed
     * will be true.
     */
    @Generated
    private Boolean managed;

    /**
     * Creates an instance of SecretBundle class.
     */
    @Generated
    private SecretBundle() {
    }

    /**
     * Get the value property: The secret value.
     * 
     * @return the value value.
     */
    @Generated
    public String getValue() {
        return this.value;
    }

    /**
     * Get the id property: The secret id.
     * 
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Get the contentType property: The content type of the secret.
     * 
     * @return the contentType value.
     */
    @Generated
    public String getContentType() {
        return this.contentType;
    }

    /**
     * Get the attributes property: The secret management attributes.
     * 
     * @return the attributes value.
     */
    @Generated
    public SecretAttributes getAttributes() {
        return this.attributes;
    }

    /**
     * Get the tags property: Application specific metadata in the form of key-value pairs.
     * 
     * @return the tags value.
     */
    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Get the kid property: If this is a secret backing a KV certificate, then this field specifies the corresponding
     * key backing the KV certificate.
     * 
     * @return the kid value.
     */
    @Generated
    public String getKid() {
        return this.kid;
    }

    /**
     * Get the managed property: True if the secret's lifetime is managed by key vault. If this is a secret backing a
     * certificate, then managed will be true.
     * 
     * @return the managed value.
     */
    @Generated
    public Boolean isManaged() {
        return this.managed;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeJsonField("attributes", this.attributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecretBundle from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecretBundle if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SecretBundle.
     */
    @Generated
    public static SecretBundle fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecretBundle deserializedSecretBundle = new SecretBundle();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedSecretBundle.value = reader.getString();
                } else if ("id".equals(fieldName)) {
                    deserializedSecretBundle.id = reader.getString();
                } else if ("contentType".equals(fieldName)) {
                    deserializedSecretBundle.contentType = reader.getString();
                } else if ("attributes".equals(fieldName)) {
                    deserializedSecretBundle.attributes = SecretAttributes.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSecretBundle.tags = tags;
                } else if ("kid".equals(fieldName)) {
                    deserializedSecretBundle.kid = reader.getString();
                } else if ("managed".equals(fieldName)) {
                    deserializedSecretBundle.managed = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecretBundle;
        });
    }
}
