/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.secrets.implementation.models.SecretAttributes;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

public final class DeletedSecretBundle
implements JsonSerializable<DeletedSecretBundle> {
    private String value;
    private String id;
    private String contentType;
    private SecretAttributes attributes;
    private Map<String, String> tags;
    private String kid;
    private Boolean managed;
    private String recoveryId;
    private Long scheduledPurgeDate;
    private Long deletedDate;

    private DeletedSecretBundle() {
    }

    public String getValue() {
        return this.value;
    }

    public String getId() {
        return this.id;
    }

    public String getContentType() {
        return this.contentType;
    }

    public SecretAttributes getAttributes() {
        return this.attributes;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public String getKid() {
        return this.kid;
    }

    public Boolean isManaged() {
        return this.managed;
    }

    public String getRecoveryId() {
        return this.recoveryId;
    }

    public OffsetDateTime getScheduledPurgeDate() {
        if (this.scheduledPurgeDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.scheduledPurgeDate), ZoneOffset.UTC);
    }

    public OffsetDateTime getDeletedDate() {
        if (this.deletedDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.deletedDate), ZoneOffset.UTC);
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.attributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("recoveryId", this.recoveryId);
        return jsonWriter.writeEndObject();
    }

    public static DeletedSecretBundle fromJson(JsonReader jsonReader) throws IOException {
        return (DeletedSecretBundle)jsonReader.readObject(reader -> {
            DeletedSecretBundle deserializedDeletedSecretBundle = new DeletedSecretBundle();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    deserializedDeletedSecretBundle.value = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedDeletedSecretBundle.id = reader.getString();
                    continue;
                }
                if ("contentType".equals(fieldName)) {
                    deserializedDeletedSecretBundle.contentType = reader.getString();
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedDeletedSecretBundle.attributes = SecretAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedDeletedSecretBundle.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("kid".equals(fieldName)) {
                    deserializedDeletedSecretBundle.kid = reader.getString();
                    continue;
                }
                if ("managed".equals(fieldName)) {
                    deserializedDeletedSecretBundle.managed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("recoveryId".equals(fieldName)) {
                    deserializedDeletedSecretBundle.recoveryId = reader.getString();
                    continue;
                }
                if ("scheduledPurgeDate".equals(fieldName)) {
                    deserializedDeletedSecretBundle.scheduledPurgeDate = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("deletedDate".equals(fieldName)) {
                    deserializedDeletedSecretBundle.deletedDate = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeletedSecretBundle;
        });
    }
}

