/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets.models;

import com.azure.security.keyvault.secrets.models.SecretProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;

public class KeyVaultSecret {
    @JsonProperty(value="value")
    private String value;
    private SecretProperties properties;

    KeyVaultSecret() {
        this.properties = new SecretProperties();
    }

    public KeyVaultSecret(String name, String value) {
        this.properties = new SecretProperties(name);
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String getId() {
        return this.properties.getId();
    }

    public String getName() {
        return this.properties.getName();
    }

    public SecretProperties getProperties() {
        return this.properties;
    }

    public KeyVaultSecret setProperties(SecretProperties properties) {
        Objects.requireNonNull(properties);
        properties.name = this.properties.name;
        this.properties = properties;
        return this;
    }

    @JsonProperty(value="id")
    private void unpackId(String id) {
        this.properties.unpackId(id);
    }

    @JsonProperty(value="attributes")
    private void unpackAttributes(Map<String, Object> attributes) {
        this.properties.unpackAttributes(attributes);
    }

    @JsonProperty(value="managed")
    private void unpackManaged(Boolean managed) {
        this.properties.managed = managed;
    }

    @JsonProperty(value="kid")
    private void unpackKid(String kid) {
        this.properties.keyId = kid;
    }

    @JsonProperty(value="contentType")
    private void unpackContentType(String contentType) {
        this.properties.contentType = contentType;
    }

    @JsonProperty(value="tags")
    private void unpackTags(Map<String, String> tags) {
        this.properties.tags = tags;
    }
}

