/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import com.azure.security.keyvault.secrets.KeyVaultErrorCodeStrings;
import com.azure.security.keyvault.secrets.SecretBackup;
import com.azure.security.keyvault.secrets.SecretRequestAttributes;
import com.azure.security.keyvault.secrets.SecretRequestParameters;
import com.azure.security.keyvault.secrets.SecretRestoreRequestParameters;
import com.azure.security.keyvault.secrets.SecretService;
import com.azure.security.keyvault.secrets.SecretServiceVersion;
import com.azure.security.keyvault.secrets.models.DeletedSecret;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.azure.security.keyvault.secrets.models.SecretProperties;
import java.net.URL;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public final class SecretAsyncClient {
    private final String apiVersion;
    static final String ACCEPT_LANGUAGE = "en-US";
    static final int DEFAULT_MAX_PAGE_RESULTS = 25;
    static final String CONTENT_TYPE_HEADER_VALUE = "application/json";
    static final String KEY_VAULT_SCOPE = "https://vault.azure.net/.default";
    private static final String KEYVAULT_TRACING_NAMESPACE_VALUE = "Microsoft.KeyVault";
    private static final Duration DEFAULT_POLLING_INTERVAL = Duration.ofSeconds(1L);
    private final String vaultUrl;
    private final SecretService service;
    private final ClientLogger logger = new ClientLogger(SecretAsyncClient.class);

    SecretAsyncClient(URL vaultUrl, HttpPipeline pipeline, SecretServiceVersion version) {
        Objects.requireNonNull(vaultUrl, KeyVaultErrorCodeStrings.getErrorString("vault_endpoint_required"));
        this.vaultUrl = vaultUrl.toString();
        this.service = (SecretService)RestProxy.create(SecretService.class, (HttpPipeline)pipeline);
        this.apiVersion = version.getVersion();
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    Duration getDefaultPollingInterval() {
        return DEFAULT_POLLING_INTERVAL;
    }

    public Mono<KeyVaultSecret> setSecret(KeyVaultSecret secret) {
        try {
            return this.setSecretWithResponse(secret).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<KeyVaultSecret>> setSecretWithResponse(KeyVaultSecret secret) {
        try {
            return FluxUtil.withContext(context -> this.setSecretWithResponse(secret, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultSecret>> setSecretWithResponse(KeyVaultSecret secret, Context context) {
        Objects.requireNonNull(secret, "The Secret input parameter cannot be null.");
        context = context == null ? Context.NONE : context;
        SecretRequestParameters parameters = new SecretRequestParameters().setValue(secret.getValue()).setTags(secret.getProperties().getTags()).setContentType(secret.getProperties().getContentType()).setSecretAttributes(new SecretRequestAttributes(secret.getProperties()));
        return this.service.setSecret(this.vaultUrl, secret.getName(), this.apiVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.info("Setting secret - {}", new Object[]{secret.getName()})).doOnSuccess(response -> this.logger.info("Set secret - {}", new Object[]{((KeyVaultSecret)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to set secret - {}", new Object[]{secret.getName(), error}));
    }

    public Mono<KeyVaultSecret> setSecret(String name, String value) {
        try {
            return FluxUtil.withContext(context -> this.setSecretWithResponse(name, value, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultSecret>> setSecretWithResponse(String name, String value, Context context) {
        SecretRequestParameters parameters = new SecretRequestParameters().setValue(value);
        return this.service.setSecret(this.vaultUrl, name, this.apiVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.info("Setting secret - {}", new Object[]{name})).doOnSuccess(response -> this.logger.info("Set secret - {}", new Object[]{((KeyVaultSecret)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to set secret - {}", new Object[]{name, error}));
    }

    public Mono<KeyVaultSecret> getSecret(String name, String version) {
        try {
            return this.getSecretWithResponse(name, version).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<KeyVaultSecret>> getSecretWithResponse(String name, String version) {
        try {
            return FluxUtil.withContext(context -> this.getSecretWithResponse(name, version, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultSecret>> getSecretWithResponse(String name, String version, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.getSecret(this.vaultUrl, name, version == null ? "" : version, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignoredValue -> this.logger.info("Retrieving secret - {}", new Object[]{name})).doOnSuccess(response -> this.logger.info("Retrieved secret - {}", new Object[]{((KeyVaultSecret)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to get secret - {}", new Object[]{name, error}));
    }

    public Mono<KeyVaultSecret> getSecret(String name) {
        try {
            return this.getSecretWithResponse(name, "").flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<SecretProperties> updateSecretProperties(SecretProperties secretProperties) {
        try {
            return this.updateSecretPropertiesWithResponse(secretProperties).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<SecretProperties>> updateSecretPropertiesWithResponse(SecretProperties secretProperties) {
        try {
            return FluxUtil.withContext(context -> this.updateSecretPropertiesWithResponse(secretProperties, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<SecretProperties>> updateSecretPropertiesWithResponse(SecretProperties secretProperties, Context context) {
        Objects.requireNonNull(secretProperties, "The secret properties input parameter cannot be null.");
        context = context == null ? Context.NONE : context;
        SecretRequestParameters parameters = new SecretRequestParameters().setTags(secretProperties.getTags()).setContentType(secretProperties.getContentType()).setSecretAttributes(new SecretRequestAttributes(secretProperties));
        return this.service.updateSecret(this.vaultUrl, secretProperties.getName(), secretProperties.getVersion(), this.apiVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.info("Updating secret - {}", new Object[]{secretProperties.getName()})).doOnSuccess(response -> this.logger.info("Updated secret - {}", new Object[]{((SecretProperties)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to update secret - {}", new Object[]{secretProperties.getName(), error}));
    }

    public PollerFlux<DeletedSecret, Void> beginDeleteSecret(String name) {
        return this.beginDeleteSecret(name, this.getDefaultPollingInterval());
    }

    public PollerFlux<DeletedSecret, Void> beginDeleteSecret(String name, Duration pollingInterval) {
        return new PollerFlux(pollingInterval, this.activationOperation(name), this.createPollOperation(name), (pollingContext, firstResponse) -> Mono.empty(), pollingContext -> Mono.empty());
    }

    private Function<PollingContext<DeletedSecret>, Mono<DeletedSecret>> activationOperation(String name) {
        return pollingContext -> FluxUtil.withContext(context -> this.deleteSecretWithResponse(name, (Context)context)).flatMap(deletedSecretResponse -> Mono.just((Object)((DeletedSecret)deletedSecretResponse.getValue())));
    }

    private Function<PollingContext<DeletedSecret>, Mono<PollResponse<DeletedSecret>>> createPollOperation(String keyName) {
        return pollingContext -> FluxUtil.withContext(context -> this.service.getDeletedSecretPoller(this.vaultUrl, keyName, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE))).flatMap(deletedSecretResponse -> {
            if (deletedSecretResponse.getStatusCode() == 404) {
                return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((DeletedSecret)pollingContext.getLatestResponse().getValue()))));
            }
            return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedSecret)deletedSecretResponse.getValue()))));
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedSecret)pollingContext.getLatestResponse().getValue())));
    }

    Mono<Response<DeletedSecret>> deleteSecretWithResponse(String name, Context context) {
        return this.service.deleteSecret(this.vaultUrl, name, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.info("Deleting secret - {}", new Object[]{name})).doOnSuccess(response -> this.logger.info("Deleted secret - {}", new Object[]{((DeletedSecret)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to delete secret - {}", new Object[]{name, error}));
    }

    public Mono<DeletedSecret> getDeletedSecret(String name) {
        try {
            return this.getDeletedSecretWithResponse(name).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<DeletedSecret>> getDeletedSecretWithResponse(String name) {
        try {
            return FluxUtil.withContext(context -> this.getDeletedSecretWithResponse(name, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<DeletedSecret>> getDeletedSecretWithResponse(String name, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.getDeletedSecret(this.vaultUrl, name, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.info("Retrieving deleted secret - {}", new Object[]{name})).doOnSuccess(response -> this.logger.info("Retrieved deleted secret - {}", new Object[]{((DeletedSecret)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to retrieve deleted secret - {}", new Object[]{name, error}));
    }

    public Mono<Void> purgeDeletedSecret(String name) {
        try {
            return this.purgeDeletedSecretWithResponse(name).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> purgeDeletedSecretWithResponse(String name) {
        try {
            return FluxUtil.withContext(context -> this.purgeDeletedSecretWithResponse(name, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> purgeDeletedSecretWithResponse(String name, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.purgeDeletedSecret(this.vaultUrl, name, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.info("Purging deleted secret - {}", new Object[]{name})).doOnSuccess(response -> this.logger.info("Purged deleted secret - {}", new Object[]{name})).doOnError(error -> this.logger.warning("Failed to purge deleted secret - {}", new Object[]{name, error}));
    }

    public PollerFlux<KeyVaultSecret, Void> beginRecoverDeletedSecret(String name) {
        return this.beginRecoverDeletedSecret(name, this.getDefaultPollingInterval());
    }

    public PollerFlux<KeyVaultSecret, Void> beginRecoverDeletedSecret(String name, Duration pollingInterval) {
        return new PollerFlux(pollingInterval, this.recoverActivationOperation(name), this.createRecoverPollOperation(name), (pollerContext, firstResponse) -> Mono.empty(), pollingContext -> Mono.empty());
    }

    private Function<PollingContext<KeyVaultSecret>, Mono<KeyVaultSecret>> recoverActivationOperation(String name) {
        return pollingContext -> FluxUtil.withContext(context -> this.recoverDeletedSecretWithResponse(name, (Context)context)).flatMap(keyResponse -> Mono.just((Object)((KeyVaultSecret)keyResponse.getValue())));
    }

    private Function<PollingContext<KeyVaultSecret>, Mono<PollResponse<KeyVaultSecret>>> createRecoverPollOperation(String secretName) {
        return pollingContext -> FluxUtil.withContext(context -> this.service.getSecretPoller(this.vaultUrl, secretName, "", this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE))).flatMap(secretResponse -> {
            PollResponse prePollResponse = pollingContext.getLatestResponse();
            if (secretResponse.getStatusCode() == 404) {
                return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((KeyVaultSecret)prePollResponse.getValue()))));
            }
            return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultSecret)secretResponse.getValue()))));
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultSecret)pollingContext.getLatestResponse().getValue())));
    }

    Mono<Response<KeyVaultSecret>> recoverDeletedSecretWithResponse(String name, Context context) {
        return this.service.recoverDeletedSecret(this.vaultUrl, name, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.info("Recovering deleted secret - {}", new Object[]{name})).doOnSuccess(response -> this.logger.info("Recovered deleted secret - {}", new Object[]{((KeyVaultSecret)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to recover deleted secret - {}", new Object[]{name, error}));
    }

    public Mono<byte[]> backupSecret(String name) {
        try {
            return this.backupSecretWithResponse(name).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<byte[]>> backupSecretWithResponse(String name) {
        try {
            return FluxUtil.withContext(context -> this.backupSecretWithResponse(name, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<byte[]>> backupSecretWithResponse(String name, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.backupSecret(this.vaultUrl, name, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.info("Backing up secret - {}", new Object[]{name})).doOnSuccess(response -> this.logger.info("Backed up secret - {}", new Object[]{name})).doOnError(error -> this.logger.warning("Failed to back up secret - {}", new Object[]{name, error})).flatMap(base64URLResponse -> Mono.just((Object)new SimpleResponse(base64URLResponse.getRequest(), base64URLResponse.getStatusCode(), base64URLResponse.getHeaders(), (Object)((SecretBackup)base64URLResponse.getValue()).getValue())));
    }

    public Mono<KeyVaultSecret> restoreSecretBackup(byte[] backup) {
        try {
            return this.restoreSecretBackupWithResponse(backup).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<KeyVaultSecret>> restoreSecretBackupWithResponse(byte[] backup) {
        try {
            return FluxUtil.withContext(context -> this.restoreSecretBackupWithResponse(backup, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultSecret>> restoreSecretBackupWithResponse(byte[] backup, Context context) {
        context = context == null ? Context.NONE : context;
        SecretRestoreRequestParameters parameters = new SecretRestoreRequestParameters().setSecretBackup(backup);
        return this.service.restoreSecret(this.vaultUrl, this.apiVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.info("Attempting to restore secret")).doOnSuccess(response -> this.logger.info("Restored secret - {}", new Object[]{((KeyVaultSecret)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to restore secret", new Object[]{error}));
    }

    public PagedFlux<SecretProperties> listPropertiesOfSecrets() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listSecretsFirstPage((Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listSecretsNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<SecretProperties> listPropertiesOfSecrets(Context context) {
        return new PagedFlux(() -> this.listSecretsFirstPage(context), continuationToken -> this.listSecretsNextPage((String)continuationToken, context));
    }

    private Mono<PagedResponse<SecretProperties>> listSecretsNextPage(String continuationToken, Context context) {
        try {
            return this.service.getSecrets(this.vaultUrl, continuationToken, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignoredValue -> this.logger.info("Retrieving the next secrets page - Page {}", new Object[]{continuationToken})).doOnSuccess(response -> this.logger.info("Retrieved the next secrets page - Page {}", new Object[]{continuationToken})).doOnError(error -> this.logger.warning("Failed to retrieve the next secrets page - Page {}", new Object[]{continuationToken, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<SecretProperties>> listSecretsFirstPage(Context context) {
        try {
            return this.service.getSecrets(this.vaultUrl, 25, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.info("Listing secrets")).doOnSuccess(response -> this.logger.info("Listed secrets")).doOnError(error -> this.logger.warning("Failed to list secrets", new Object[]{error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public PagedFlux<DeletedSecret> listDeletedSecrets() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listDeletedSecretsFirstPage((Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listDeletedSecretsNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<DeletedSecret> listDeletedSecrets(Context context) {
        return new PagedFlux(() -> this.listDeletedSecretsFirstPage(context), continuationToken -> this.listDeletedSecretsNextPage((String)continuationToken, context));
    }

    private Mono<PagedResponse<DeletedSecret>> listDeletedSecretsNextPage(String continuationToken, Context context) {
        try {
            return this.service.getDeletedSecrets(this.vaultUrl, continuationToken, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignoredValue -> this.logger.info("Retrieving the next deleted secrets page - Page {}", new Object[]{continuationToken})).doOnSuccess(response -> this.logger.info("Retrieved the next deleted secrets page - Page {}", new Object[]{continuationToken})).doOnError(error -> this.logger.warning("Failed to retrieve the next deleted secrets page - Page {}", new Object[]{continuationToken, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<DeletedSecret>> listDeletedSecretsFirstPage(Context context) {
        try {
            return this.service.getDeletedSecrets(this.vaultUrl, 25, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.info("Listing deleted secrets")).doOnSuccess(response -> this.logger.info("Listed deleted secrets")).doOnError(error -> this.logger.warning("Failed to list deleted secrets", new Object[]{error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public PagedFlux<SecretProperties> listPropertiesOfSecretVersions(String name) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listSecretVersionsFirstPage(name, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listSecretVersionsNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<SecretProperties> listPropertiesOfSecretVersions(String name, Context context) {
        return new PagedFlux(() -> this.listSecretVersionsFirstPage(name, context), continuationToken -> this.listSecretVersionsNextPage((String)continuationToken, context));
    }

    private Mono<PagedResponse<SecretProperties>> listSecretVersionsNextPage(String continuationToken, Context context) {
        try {
            return this.service.getSecrets(this.vaultUrl, continuationToken, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignoredValue -> this.logger.info("Retrieving the next secrets versions page - Page {}", new Object[]{continuationToken})).doOnSuccess(response -> this.logger.info("Retrieved the next secrets versions page - Page {}", new Object[]{continuationToken})).doOnError(error -> this.logger.warning("Failed to retrieve the next secrets versions page - Page {}", new Object[]{continuationToken, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<SecretProperties>> listSecretVersionsFirstPage(String name, Context context) {
        try {
            return this.service.getSecretVersions(this.vaultUrl, name, 25, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.info("Listing secret versions - {}", new Object[]{name})).doOnSuccess(response -> this.logger.info("Listed secret versions - {}", new Object[]{name})).doOnError(error -> this.logger.warning(String.format("Failed to list secret versions - {}", name), new Object[]{error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }
}

