/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets.models;

import java.net.MalformedURLException;
import java.net.URL;

public final class KeyVaultSecretIdentifier {
    private final String secretId;
    private final String vaultUrl;
    private final String name;
    private final String version;

    private KeyVaultSecretIdentifier(String secretId, String vaultUrl, String name, String version) {
        this.secretId = secretId;
        this.vaultUrl = vaultUrl;
        this.name = name;
        this.version = version;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public static KeyVaultSecretIdentifier parse(String secretId) throws IllegalArgumentException {
        if (secretId == null) {
            throw new IllegalArgumentException("secretId cannot be null");
        }
        try {
            URL url = new URL(secretId);
            String[] pathSegments = url.getPath().split("/");
            if (pathSegments.length != 3 && pathSegments.length != 4 || !"https".equals(url.getProtocol()) || !"secrets".equals(pathSegments[1]) && !"deletedsecrets".equals(pathSegments[1]) || "deletedsecrets".equals(pathSegments[1]) && pathSegments.length == 4) {
                throw new IllegalArgumentException("secretId is not a valid Key Vault Secret identifier");
            }
            String vaultUrl = String.format("%s://%s", url.getProtocol(), url.getHost());
            String secretName = pathSegments[2];
            String secretVersion = pathSegments.length == 4 ? pathSegments[3] : null;
            return new KeyVaultSecretIdentifier(secretId, vaultUrl, secretName, secretVersion);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not parse secretId", e);
        }
    }
}

