/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets.implementation;

import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class KeyVaultCredentialPolicy
extends BearerTokenAuthenticationPolicy {
    private static final String BEARER_TOKEN_PREFIX = "Bearer ";
    private static final String CONTENT_LENGTH_HEADER = "Content-Length";
    private static final String KEY_VAULT_STASHED_CONTENT_KEY = "KeyVaultCredentialPolicyStashedBody";
    private static final String KEY_VAULT_STASHED_CONTENT_LENGTH_KEY = "KeyVaultCredentialPolicyStashedContentLength";
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final ConcurrentMap<String, ChallengeParameters> CHALLENGE_CACHE = new ConcurrentHashMap<String, ChallengeParameters>();
    private ChallengeParameters challenge;

    public KeyVaultCredentialPolicy(TokenCredential credential) {
        super(credential, new String[0]);
    }

    private static Map<String, String> extractChallengeAttributes(String authenticateHeader, String authChallengePrefix) {
        if (!KeyVaultCredentialPolicy.isBearerChallenge(authenticateHeader, authChallengePrefix)) {
            return Collections.emptyMap();
        }
        authenticateHeader = authenticateHeader.toLowerCase(Locale.ROOT).replace(authChallengePrefix.toLowerCase(Locale.ROOT), "");
        String[] attributes = authenticateHeader.split(", ");
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        for (String pair : attributes) {
            String[] keyValue = pair.split("=");
            attributeMap.put(keyValue[0].replaceAll("\"", ""), keyValue[1].replaceAll("\"", ""));
        }
        return attributeMap;
    }

    private static boolean isBearerChallenge(String authenticateHeader, String authChallengePrefix) {
        return !CoreUtils.isNullOrEmpty((CharSequence)authenticateHeader) && authenticateHeader.toLowerCase(Locale.ROOT).startsWith(authChallengePrefix.toLowerCase(Locale.ROOT));
    }

    public Mono<Void> authorizeRequest(HttpPipelineCallContext context) {
        return Mono.defer(() -> {
            HttpRequest request = context.getHttpRequest();
            if (this.challenge == null) {
                String authority = KeyVaultCredentialPolicy.getRequestAuthority(request);
                this.challenge = (ChallengeParameters)CHALLENGE_CACHE.get(authority);
            }
            if (this.challenge != null) {
                TokenRequestContext tokenRequestContext = new TokenRequestContext().addScopes(this.challenge.getScopes()).setTenantId(this.challenge.getTenantId());
                return this.setAuthorizationHeader(context, tokenRequestContext);
            }
            if (!context.getData(KEY_VAULT_STASHED_CONTENT_KEY).isPresent() && request.getBody() != null) {
                context.setData(KEY_VAULT_STASHED_CONTENT_KEY, (Object)request.getBody());
                context.setData(KEY_VAULT_STASHED_CONTENT_LENGTH_KEY, (Object)request.getHeaders().getValue(CONTENT_LENGTH_HEADER));
                request.setHeader(CONTENT_LENGTH_HEADER, "0");
                request.setBody((Flux)null);
            }
            return Mono.empty();
        });
    }

    public Mono<Boolean> authorizeRequestOnChallenge(HttpPipelineCallContext context, HttpResponse response) {
        return Mono.defer(() -> {
            HttpRequest request = context.getHttpRequest();
            Optional contentOptional = context.getData(KEY_VAULT_STASHED_CONTENT_KEY);
            Optional contentLengthOptional = context.getData(KEY_VAULT_STASHED_CONTENT_LENGTH_KEY);
            if (request.getBody() == null && contentOptional.isPresent() && contentLengthOptional.isPresent()) {
                request.setBody((Flux)contentOptional.get());
                request.setHeader(CONTENT_LENGTH_HEADER, (String)contentLengthOptional.get());
            }
            String authority = KeyVaultCredentialPolicy.getRequestAuthority(request);
            Map<String, String> challengeAttributes = KeyVaultCredentialPolicy.extractChallengeAttributes(response.getHeaderValue(WWW_AUTHENTICATE), BEARER_TOKEN_PREFIX);
            String scope = challengeAttributes.get("resource");
            scope = scope != null ? scope + "/.default" : challengeAttributes.get("scope");
            if (scope == null) {
                this.challenge = (ChallengeParameters)CHALLENGE_CACHE.get(authority);
                if (this.challenge == null) {
                    return Mono.just((Object)false);
                }
            } else {
                URI authorizationUri;
                String authorization = challengeAttributes.get("authorization");
                if (authorization == null) {
                    authorization = challengeAttributes.get("authorization_uri");
                }
                try {
                    authorizationUri = new URI(authorization);
                }
                catch (URISyntaxException e) {
                    return Mono.just((Object)false);
                }
                this.challenge = new ChallengeParameters(authorizationUri, new String[]{scope});
                CHALLENGE_CACHE.put(authority, this.challenge);
            }
            TokenRequestContext tokenRequestContext = new TokenRequestContext().addScopes(this.challenge.getScopes()).setTenantId(this.challenge.getTenantId());
            return this.setAuthorizationHeader(context, tokenRequestContext).then(Mono.just((Object)true));
        });
    }

    public void authorizeRequestSync(HttpPipelineCallContext context) {
        HttpRequest request = context.getHttpRequest();
        if (this.challenge == null) {
            String authority = KeyVaultCredentialPolicy.getRequestAuthority(request);
            this.challenge = (ChallengeParameters)CHALLENGE_CACHE.get(authority);
        }
        if (this.challenge != null) {
            TokenRequestContext tokenRequestContext = new TokenRequestContext().addScopes(this.challenge.getScopes()).setTenantId(this.challenge.getTenantId());
            this.setAuthorizationHeaderSync(context, tokenRequestContext);
            return;
        }
        if (!context.getData(KEY_VAULT_STASHED_CONTENT_KEY).isPresent() && request.getBodyAsBinaryData() != null) {
            context.setData(KEY_VAULT_STASHED_CONTENT_KEY, (Object)request.getBodyAsBinaryData());
            context.setData(KEY_VAULT_STASHED_CONTENT_LENGTH_KEY, (Object)request.getHeaders().getValue(CONTENT_LENGTH_HEADER));
            request.setHeader(CONTENT_LENGTH_HEADER, "0");
            request.setBody((BinaryData)null);
        }
    }

    public boolean authorizeRequestOnChallengeSync(HttpPipelineCallContext context, HttpResponse response) {
        HttpRequest request = context.getHttpRequest();
        Optional contentOptional = context.getData(KEY_VAULT_STASHED_CONTENT_KEY);
        Optional contentLengthOptional = context.getData(KEY_VAULT_STASHED_CONTENT_LENGTH_KEY);
        if (request.getBody() == null && contentOptional.isPresent() && contentLengthOptional.isPresent()) {
            request.setBody((BinaryData)contentOptional.get());
            request.setHeader(CONTENT_LENGTH_HEADER, (String)contentLengthOptional.get());
        }
        String authority = KeyVaultCredentialPolicy.getRequestAuthority(request);
        Map<String, String> challengeAttributes = KeyVaultCredentialPolicy.extractChallengeAttributes(response.getHeaderValue(WWW_AUTHENTICATE), BEARER_TOKEN_PREFIX);
        String scope = challengeAttributes.get("resource");
        scope = scope != null ? scope + "/.default" : challengeAttributes.get("scope");
        if (scope == null) {
            this.challenge = (ChallengeParameters)CHALLENGE_CACHE.get(authority);
            if (this.challenge == null) {
                return false;
            }
        } else {
            URI authorizationUri;
            String authorization = challengeAttributes.get("authorization");
            if (authorization == null) {
                authorization = challengeAttributes.get("authorization_uri");
            }
            try {
                authorizationUri = new URI(authorization);
            }
            catch (URISyntaxException e) {
                return false;
            }
            this.challenge = new ChallengeParameters(authorizationUri, new String[]{scope});
            CHALLENGE_CACHE.put(authority, this.challenge);
        }
        TokenRequestContext tokenRequestContext = new TokenRequestContext().addScopes(this.challenge.getScopes()).setTenantId(this.challenge.getTenantId());
        this.setAuthorizationHeaderSync(context, tokenRequestContext);
        return true;
    }

    public static void clearCache() {
        CHALLENGE_CACHE.clear();
    }

    private static String getRequestAuthority(HttpRequest request) {
        URL url = request.getUrl();
        String authority = url.getAuthority();
        int port = url.getPort();
        if (!authority.contains(":") && port > 0) {
            authority = authority + ":" + port;
        }
        return authority;
    }

    private static class ChallengeParameters {
        private final URI authorizationUri;
        private final String tenantId;
        private final String[] scopes;

        ChallengeParameters(URI authorizationUri, String[] scopes) {
            this.authorizationUri = authorizationUri;
            this.tenantId = authorizationUri.getPath().split("/")[1];
            this.scopes = scopes;
        }

        public URI getAuthorizationUri() {
            return this.authorizationUri;
        }

        public String[] getScopes() {
            return this.scopes;
        }

        public String getTenantId() {
            return this.tenantId;
        }
    }
}

