// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.secrets.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

/** The secret restore parameters. */
@Fluent
public final class SecretRestoreParameters implements JsonSerializable<SecretRestoreParameters> {
    /*
     * The backup blob associated with a secret bundle.
     */
    private Base64Url secretBundleBackup;

    /** Creates an instance of SecretRestoreParameters class. */
    public SecretRestoreParameters() {}

    /**
     * Get the secretBundleBackup property: The backup blob associated with a secret bundle.
     *
     * @return the secretBundleBackup value.
     */
    public byte[] getSecretBundleBackup() {
        if (this.secretBundleBackup == null) {
            return new byte[0];
        }
        return this.secretBundleBackup.decodedBytes();
    }

    /**
     * Set the secretBundleBackup property: The backup blob associated with a secret bundle.
     *
     * @param secretBundleBackup the secretBundleBackup value to set.
     * @return the SecretRestoreParameters object itself.
     */
    public SecretRestoreParameters setSecretBundleBackup(byte[] secretBundleBackup) {
        if (secretBundleBackup == null) {
            this.secretBundleBackup = null;
        } else {
            this.secretBundleBackup = Base64Url.encode(CoreUtils.clone(secretBundleBackup));
        }
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", Objects.toString(this.secretBundleBackup, null));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecretRestoreParameters from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecretRestoreParameters if the JsonReader was pointing to an instance of it, or null if it
     *     was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SecretRestoreParameters.
     */
    public static SecretRestoreParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    SecretRestoreParameters deserializedSecretRestoreParameters = new SecretRestoreParameters();
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();

                        if ("value".equals(fieldName)) {
                            deserializedSecretRestoreParameters.secretBundleBackup =
                                    reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                        } else {
                            reader.skipChildren();
                        }
                    }

                    return deserializedSecretRestoreParameters;
                });
    }
}
