// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.secrets.implementation.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.Base64Url;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/** The backup secret result, containing the backup blob. */
@Immutable
public final class BackupSecretResult implements JsonSerializable<BackupSecretResult> {
    /*
     * The backup blob containing the backed up secret.
     */
    private Base64Url value;

    /** Creates an instance of BackupSecretResult class. */
    public BackupSecretResult() {
    }

    /**
     * Get the value property: The backup blob containing the backed up secret.
     *
     * @return the value value.
     */
    public byte[] getValue() {
        if (this.value == null) {
            return null;
        }
        return this.value.decodedBytes();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BackupSecretResult from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of BackupSecretResult if the JsonReader was pointing to an instance of it, or null if it was
     *     pointing to JSON null.
     * @throws IOException If an error occurs while reading the BackupSecretResult.
     */
    public static BackupSecretResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BackupSecretResult deserializedBackupSecretResult = new BackupSecretResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedBackupSecretResult.value
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBackupSecretResult;
        });
    }
}
