/*
 * Decompiled with CFR 0.152.
 */
package com.azure.servicebus.jms;

import com.azure.servicebus.jms.ServiceBusJmsConnection;
import com.azure.servicebus.jms.ServiceBusJmsQueueSession;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionConsumer;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueSession;
import jakarta.jms.ServerSessionPool;

class ServiceBusJmsQueueConnection
extends ServiceBusJmsConnection
implements QueueConnection {
    private final QueueConnection innerQueueConnection;

    ServiceBusJmsQueueConnection(QueueConnection innerQueueConnection) {
        super((Connection)innerQueueConnection);
        this.innerQueueConnection = innerQueueConnection;
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        QueueSession innerQueueSession = this.innerQueueConnection.createQueueSession(transacted, acknowledgeMode);
        return new ServiceBusJmsQueueSession(innerQueueSession);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.innerQueueConnection.createConnectionConsumer(queue, messageSelector, sessionPool, maxMessages);
    }
}

