/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.core;

import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosContainerResponse;
import com.azure.cosmos.models.CosmosItemRequestOptions;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.models.ThroughputProperties;
import com.azure.spring.data.cosmos.CosmosFactory;
import com.azure.spring.data.cosmos.common.CosmosUtils;
import com.azure.spring.data.cosmos.config.CosmosConfig;
import com.azure.spring.data.cosmos.core.ReactiveCosmosOperations;
import com.azure.spring.data.cosmos.core.ResponseDiagnosticsProcessor;
import com.azure.spring.data.cosmos.core.convert.MappingCosmosConverter;
import com.azure.spring.data.cosmos.core.generator.CountQueryGenerator;
import com.azure.spring.data.cosmos.core.generator.FindQuerySpecGenerator;
import com.azure.spring.data.cosmos.core.query.CosmosQuery;
import com.azure.spring.data.cosmos.core.query.Criteria;
import com.azure.spring.data.cosmos.core.query.CriteriaType;
import com.azure.spring.data.cosmos.exception.CosmosExceptionUtils;
import com.azure.spring.data.cosmos.repository.support.CosmosEntityInformation;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Field;
import java.util.UUID;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class ReactiveCosmosTemplate
implements ReactiveCosmosOperations,
ApplicationContextAware {
    private final MappingCosmosConverter mappingCosmosConverter;
    private final String databaseName;
    private final ResponseDiagnosticsProcessor responseDiagnosticsProcessor;
    private final boolean queryMetricsEnabled;
    private final CosmosAsyncClient cosmosAsyncClient;
    private final IsNewAwareAuditingHandler cosmosAuditingHandler;

    public ReactiveCosmosTemplate(CosmosAsyncClient client, String databaseName, CosmosConfig cosmosConfig, MappingCosmosConverter mappingCosmosConverter, IsNewAwareAuditingHandler cosmosAuditingHandler) {
        this(new CosmosFactory(client, databaseName), cosmosConfig, mappingCosmosConverter, cosmosAuditingHandler);
    }

    public ReactiveCosmosTemplate(CosmosAsyncClient client, String databaseName, CosmosConfig cosmosConfig, MappingCosmosConverter mappingCosmosConverter) {
        this(new CosmosFactory(client, databaseName), cosmosConfig, mappingCosmosConverter, null);
    }

    public ReactiveCosmosTemplate(CosmosFactory cosmosFactory, CosmosConfig cosmosConfig, MappingCosmosConverter mappingCosmosConverter, IsNewAwareAuditingHandler cosmosAuditingHandler) {
        Assert.notNull((Object)cosmosFactory, (String)"CosmosFactory must not be null!");
        Assert.notNull((Object)cosmosConfig, (String)"CosmosConfig must not be null!");
        Assert.notNull((Object)mappingCosmosConverter, (String)"MappingCosmosConverter must not be null!");
        this.mappingCosmosConverter = mappingCosmosConverter;
        this.cosmosAsyncClient = cosmosFactory.getCosmosAsyncClient();
        this.databaseName = cosmosFactory.getDatabaseName();
        this.responseDiagnosticsProcessor = cosmosConfig.getResponseDiagnosticsProcessor();
        this.queryMetricsEnabled = cosmosConfig.isQueryMetricsEnabled();
        this.cosmosAuditingHandler = cosmosAuditingHandler;
    }

    public ReactiveCosmosTemplate(CosmosFactory cosmosFactory, CosmosConfig cosmosConfig, MappingCosmosConverter mappingCosmosConverter) {
        this(cosmosFactory, cosmosConfig, mappingCosmosConverter, null);
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
    }

    @Override
    public Mono<CosmosContainerResponse> createContainerIfNotExists(CosmosEntityInformation<?, ?> information) {
        return this.cosmosAsyncClient.createDatabaseIfNotExists(this.databaseName).publishOn(Schedulers.parallel()).onErrorResume(throwable -> CosmosExceptionUtils.exceptionHandler("Failed to create database", throwable)).flatMap(cosmosDatabaseResponse -> {
            Mono cosmosContainerResponseMono;
            CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosDatabaseResponse.getDiagnostics(), null);
            CosmosContainerProperties cosmosContainerProperties = new CosmosContainerProperties(information.getContainerName(), information.getPartitionKeyPath());
            cosmosContainerProperties.setDefaultTimeToLiveInSeconds(information.getTimeToLive());
            cosmosContainerProperties.setIndexingPolicy(information.getIndexingPolicy());
            CosmosAsyncDatabase database = this.cosmosAsyncClient.getDatabase(cosmosDatabaseResponse.getProperties().getId());
            if (information.getRequestUnit() == null) {
                cosmosContainerResponseMono = database.createContainerIfNotExists(cosmosContainerProperties);
            } else {
                ThroughputProperties throughputProperties = ThroughputProperties.createManualThroughput((int)information.getRequestUnit());
                cosmosContainerResponseMono = database.createContainerIfNotExists(cosmosContainerProperties, throughputProperties);
            }
            return cosmosContainerResponseMono.map(cosmosContainerResponse -> {
                CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosContainerResponse.getDiagnostics(), null);
                return cosmosContainerResponse;
            }).onErrorResume(throwable -> CosmosExceptionUtils.exceptionHandler("Failed to create container", throwable));
        });
    }

    @Override
    public <T> Flux<T> findAll(String containerName, Class<T> domainType) {
        CosmosQuery query = new CosmosQuery(Criteria.getInstance(CriteriaType.ALL));
        return this.find(query, domainType, containerName);
    }

    @Override
    public <T> Flux<T> findAll(Class<T> domainType) {
        return this.findAll(domainType.getSimpleName(), domainType);
    }

    @Override
    public <T> Flux<T> findAll(PartitionKey partitionKey, Class<T> domainType) {
        Assert.notNull((Object)partitionKey, (String)"partitionKey should not be null");
        Assert.notNull(domainType, (String)"domainType should not be null");
        String containerName = this.getContainerName(domainType);
        CosmosQueryRequestOptions cosmosQueryRequestOptions = new CosmosQueryRequestOptions();
        cosmosQueryRequestOptions.setPartitionKey(partitionKey);
        cosmosQueryRequestOptions.setQueryMetricsEnabled(this.queryMetricsEnabled);
        return this.cosmosAsyncClient.getDatabase(this.databaseName).getContainer(containerName).queryItems("SELECT * FROM r", cosmosQueryRequestOptions, JsonNode.class).byPage().publishOn(Schedulers.parallel()).flatMap(cosmosItemFeedResponse -> {
            CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosItemFeedResponse.getCosmosDiagnostics(), cosmosItemFeedResponse);
            return Flux.fromIterable((Iterable)cosmosItemFeedResponse.getResults());
        }).map(cosmosItemProperties -> this.toDomainObject(domainType, (JsonNode)cosmosItemProperties)).onErrorResume(throwable -> CosmosExceptionUtils.exceptionHandler("Failed to find items", throwable));
    }

    @Override
    public <T> Mono<T> findById(Object id, Class<T> domainType) {
        Assert.notNull(domainType, (String)"domainType should not be null");
        return this.findById(this.getContainerName(domainType), id, domainType);
    }

    @Override
    public <T> Mono<T> findById(String containerName, Object id, Class<T> domainType) {
        Assert.hasText((String)containerName, (String)"containerName should not be null, empty or only whitespaces");
        Assert.notNull(domainType, (String)"domainType should not be null");
        String query = String.format("select * from root where root.id = '%s'", CosmosUtils.getStringIDValue(id));
        CosmosQueryRequestOptions options = new CosmosQueryRequestOptions();
        options.setQueryMetricsEnabled(this.queryMetricsEnabled);
        return this.cosmosAsyncClient.getDatabase(this.databaseName).getContainer(containerName).queryItems(query, options, JsonNode.class).byPage().publishOn(Schedulers.parallel()).flatMap(cosmosItemFeedResponse -> {
            CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosItemFeedResponse.getCosmosDiagnostics(), cosmosItemFeedResponse);
            return Mono.justOrEmpty(cosmosItemFeedResponse.getResults().stream().map(cosmosItem -> this.toDomainObject(domainType, (JsonNode)cosmosItem)).findFirst());
        }).onErrorResume(throwable -> CosmosExceptionUtils.findAPIExceptionHandler("Failed to find item", throwable)).next();
    }

    @Override
    public <T> Mono<T> findById(Object id, Class<T> domainType, PartitionKey partitionKey) {
        Assert.notNull(domainType, (String)"domainType should not be null");
        String idToFind = CosmosUtils.getStringIDValue(id);
        String containerName = this.getContainerName(domainType);
        return this.cosmosAsyncClient.getDatabase(this.databaseName).getContainer(containerName).readItem(idToFind, partitionKey, JsonNode.class).publishOn(Schedulers.parallel()).flatMap(cosmosItemResponse -> {
            CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosItemResponse.getDiagnostics(), null);
            return Mono.justOrEmpty(this.toDomainObject(domainType, (JsonNode)cosmosItemResponse.getItem()));
        }).onErrorResume(throwable -> CosmosExceptionUtils.findAPIExceptionHandler("Failed to find item", throwable));
    }

    @Override
    public <T> Mono<T> insert(T objectToSave, PartitionKey partitionKey) {
        return this.insert(this.getContainerName(objectToSave.getClass()), objectToSave, partitionKey);
    }

    public <T> Mono<T> insert(T objectToSave) {
        return this.insert(this.getContainerName(objectToSave.getClass()), objectToSave, null);
    }

    @Override
    public <T> Mono<T> insert(String containerName, Object objectToSave, PartitionKey partitionKey) {
        Assert.hasText((String)containerName, (String)"containerName should not be null, empty or only whitespaces");
        Assert.notNull((Object)objectToSave, (String)"objectToSave should not be null");
        Class<?> domainType = objectToSave.getClass();
        this.generateIdIfNullAndAutoGenerationEnabled(objectToSave, domainType);
        JsonNode originalItem = this.prepareToPersistAndConvertToItemProperties(objectToSave);
        CosmosItemRequestOptions options = new CosmosItemRequestOptions();
        return this.cosmosAsyncClient.getDatabase(this.databaseName).getContainer(containerName).createItem((Object)originalItem, partitionKey, options).publishOn(Schedulers.parallel()).onErrorResume(throwable -> CosmosExceptionUtils.exceptionHandler("Failed to insert item", throwable)).flatMap(cosmosItemResponse -> {
            CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosItemResponse.getDiagnostics(), null);
            return Mono.just(this.toDomainObject(domainType, (JsonNode)cosmosItemResponse.getItem()));
        });
    }

    @Override
    public <T> Mono<T> insert(String containerName, T objectToSave) {
        return this.insert(containerName, objectToSave, null);
    }

    private <T> void generateIdIfNullAndAutoGenerationEnabled(T originalItem, Class<?> type) {
        CosmosEntityInformation<?, ?> entityInfo = CosmosEntityInformation.getInstance(type);
        if (entityInfo.shouldGenerateId() && ReflectionUtils.getField((Field)entityInfo.getIdField(), originalItem) == null) {
            ReflectionUtils.setField((Field)entityInfo.getIdField(), originalItem, (Object)UUID.randomUUID().toString());
        }
    }

    @Override
    public <T> Mono<T> upsert(T object) {
        return this.upsert(this.getContainerName(object.getClass()), object);
    }

    @Override
    public <T> Mono<T> upsert(String containerName, T object) {
        Class<?> domainType = object.getClass();
        JsonNode originalItem = this.prepareToPersistAndConvertToItemProperties(object);
        CosmosItemRequestOptions options = new CosmosItemRequestOptions();
        this.applyVersioning(object.getClass(), originalItem, options);
        return this.cosmosAsyncClient.getDatabase(this.databaseName).getContainer(containerName).upsertItem((Object)originalItem, options).publishOn(Schedulers.parallel()).flatMap(cosmosItemResponse -> {
            CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosItemResponse.getDiagnostics(), null);
            return Mono.just(this.toDomainObject(domainType, (JsonNode)cosmosItemResponse.getItem()));
        }).onErrorResume(throwable -> CosmosExceptionUtils.exceptionHandler("Failed to upsert item", throwable));
    }

    @Override
    public Mono<Void> deleteById(String containerName, Object id, PartitionKey partitionKey) {
        return this.deleteById(containerName, id, partitionKey, new CosmosItemRequestOptions());
    }

    private Mono<Void> deleteById(String containerName, Object id, PartitionKey partitionKey, CosmosItemRequestOptions cosmosItemRequestOptions) {
        Assert.hasText((String)containerName, (String)"container name should not be null, empty or only whitespaces");
        String idToDelete = CosmosUtils.getStringIDValue(id);
        if (partitionKey == null) {
            partitionKey = PartitionKey.NONE;
        }
        return this.cosmosAsyncClient.getDatabase(this.databaseName).getContainer(containerName).deleteItem(idToDelete, partitionKey, cosmosItemRequestOptions).publishOn(Schedulers.parallel()).doOnNext(cosmosItemResponse -> CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosItemResponse.getDiagnostics(), null)).onErrorResume(throwable -> CosmosExceptionUtils.exceptionHandler("Failed to delete item", throwable)).then();
    }

    @Override
    public <T> Mono<Void> deleteEntity(String containerName, T entity) {
        Assert.notNull(entity, (String)"entity to be deleted should not be null");
        Class<?> domainType = entity.getClass();
        JsonNode originalItem = this.mappingCosmosConverter.writeJsonNode(entity);
        CosmosItemRequestOptions options = new CosmosItemRequestOptions();
        this.applyVersioning(entity.getClass(), originalItem, options);
        return this.deleteItem(originalItem, containerName, domainType).then();
    }

    @Override
    public Mono<Void> deleteAll(@NonNull String containerName, @NonNull Class<?> domainType) {
        Assert.hasText((String)containerName, (String)"container name should not be null, empty or only whitespaces");
        CosmosQuery query = new CosmosQuery(Criteria.getInstance(CriteriaType.ALL));
        return this.delete(query, domainType, containerName).then();
    }

    @Override
    public <T> Flux<T> delete(CosmosQuery query, Class<T> domainType, String containerName) {
        Assert.notNull((Object)query, (String)"DocumentQuery should not be null.");
        Assert.notNull(domainType, (String)"domainType should not be null.");
        Assert.hasText((String)containerName, (String)"container name should not be null, empty or only whitespaces");
        Flux<JsonNode> results = this.findItems(query, containerName);
        return results.flatMap(d -> this.deleteItem((JsonNode)d, containerName, domainType));
    }

    @Override
    public <T> Flux<T> find(CosmosQuery query, Class<T> domainType, String containerName) {
        return this.findItems(query, containerName).map(cosmosItemProperties -> this.toDomainObject(domainType, (JsonNode)cosmosItemProperties));
    }

    @Override
    public Mono<Boolean> exists(CosmosQuery query, Class<?> domainType, String containerName) {
        return this.count(query, containerName).flatMap(count -> Mono.just((Object)(count > 0L ? 1 : 0)));
    }

    @Override
    public Mono<Boolean> existsById(Object id, Class<?> domainType, String containerName) {
        return this.findById(containerName, id, domainType).flatMap(o -> Mono.just((Object)(o != null ? 1 : 0)));
    }

    @Override
    public Mono<Long> count(String containerName) {
        CosmosQuery query = new CosmosQuery(Criteria.getInstance(CriteriaType.ALL));
        return this.count(query, containerName);
    }

    @Override
    public Mono<Long> count(CosmosQuery query, String containerName) {
        return this.getCountValue(query, containerName);
    }

    @Override
    public MappingCosmosConverter getConverter() {
        return this.mappingCosmosConverter;
    }

    @Override
    public <T> Flux<T> runQuery(SqlQuerySpec querySpec, Class<?> domainType, Class<T> returnType) {
        String containerName = domainType.getSimpleName();
        CosmosQueryRequestOptions options = new CosmosQueryRequestOptions();
        return this.cosmosAsyncClient.getDatabase(this.databaseName).getContainer(containerName).queryItems(querySpec, options, returnType).byPage().publishOn(Schedulers.parallel()).flatMap(cosmosItemFeedResponse -> {
            CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosItemFeedResponse.getCosmosDiagnostics(), cosmosItemFeedResponse);
            return Flux.fromIterable((Iterable)cosmosItemFeedResponse.getResults());
        }).onErrorResume(throwable -> CosmosExceptionUtils.exceptionHandler("Failed to find items", throwable));
    }

    private Mono<Long> getCountValue(CosmosQuery query, String containerName) {
        SqlQuerySpec querySpec = new CountQueryGenerator().generateCosmos(query);
        CosmosQueryRequestOptions options = new CosmosQueryRequestOptions();
        options.setQueryMetricsEnabled(this.queryMetricsEnabled);
        return this.executeQuery(querySpec, containerName, options).doOnNext(feedResponse -> CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, feedResponse.getCosmosDiagnostics(), feedResponse)).onErrorResume(throwable -> CosmosExceptionUtils.exceptionHandler("Failed to get count value", throwable)).next().map(r -> ((JsonNode)r.getResults().get(0)).asLong());
    }

    private Flux<FeedResponse<JsonNode>> executeQuery(SqlQuerySpec sqlQuerySpec, String containerName, CosmosQueryRequestOptions options) {
        return this.cosmosAsyncClient.getDatabase(this.databaseName).getContainer(containerName).queryItems(sqlQuerySpec, options, JsonNode.class).byPage().onErrorResume(throwable -> CosmosExceptionUtils.exceptionHandler("Failed to execute query", throwable));
    }

    @Override
    public void deleteContainer(@NonNull String containerName) {
        Assert.hasText((String)containerName, (String)"containerName should have text.");
        this.cosmosAsyncClient.getDatabase(this.databaseName).getContainer(containerName).delete().doOnNext(cosmosContainerResponse -> CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosContainerResponse.getDiagnostics(), null)).onErrorResume(throwable -> CosmosExceptionUtils.exceptionHandler("Failed to delete container", throwable)).block();
    }

    @Override
    public String getContainerName(Class<?> domainType) {
        Assert.notNull(domainType, (String)"domainType should not be null");
        return CosmosEntityInformation.getInstance(domainType).getContainerName();
    }

    private JsonNode prepareToPersistAndConvertToItemProperties(Object object) {
        if (this.cosmosAuditingHandler != null) {
            this.cosmosAuditingHandler.markAudited(object);
        }
        return this.mappingCosmosConverter.writeJsonNode(object);
    }

    private Flux<JsonNode> findItems(@NonNull CosmosQuery query, @NonNull String containerName) {
        SqlQuerySpec sqlQuerySpec = new FindQuerySpecGenerator().generateCosmos(query);
        CosmosQueryRequestOptions cosmosQueryRequestOptions = new CosmosQueryRequestOptions();
        cosmosQueryRequestOptions.setQueryMetricsEnabled(this.queryMetricsEnabled);
        return this.cosmosAsyncClient.getDatabase(this.databaseName).getContainer(containerName).queryItems(sqlQuerySpec, cosmosQueryRequestOptions, JsonNode.class).byPage().publishOn(Schedulers.parallel()).flatMap(cosmosItemFeedResponse -> {
            CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosItemFeedResponse.getCosmosDiagnostics(), cosmosItemFeedResponse);
            return Flux.fromIterable((Iterable)cosmosItemFeedResponse.getResults());
        }).onErrorResume(throwable -> CosmosExceptionUtils.exceptionHandler("Failed to query items", throwable));
    }

    private <T> Mono<T> deleteItem(@NonNull JsonNode jsonNode, String containerName, @NonNull Class<T> domainType) {
        CosmosItemRequestOptions options = new CosmosItemRequestOptions();
        this.applyVersioning(domainType, jsonNode, options);
        return this.cosmosAsyncClient.getDatabase(this.databaseName).getContainer(containerName).deleteItem((Object)jsonNode, options).publishOn(Schedulers.parallel()).map(cosmosItemResponse -> {
            CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosItemResponse.getDiagnostics(), null);
            return cosmosItemResponse;
        }).flatMap(objectCosmosItemResponse -> Mono.just(this.toDomainObject(domainType, jsonNode))).onErrorResume(throwable -> CosmosExceptionUtils.exceptionHandler("Failed to delete item", throwable));
    }

    private <T> T toDomainObject(@NonNull Class<T> domainType, JsonNode jsonNode) {
        return this.mappingCosmosConverter.read(domainType, jsonNode);
    }

    private void applyVersioning(Class<?> domainType, JsonNode jsonNode, CosmosItemRequestOptions options) {
        CosmosEntityInformation<?, ?> entityInformation = CosmosEntityInformation.getInstance(domainType);
        if (entityInformation.isVersioned()) {
            options.setIfMatchETag(jsonNode.get("_etag").asText());
        }
    }
}

