/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.common;

import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.models.FeedResponse;
import com.azure.spring.data.cosmos.core.ResponseDiagnostics;
import com.azure.spring.data.cosmos.core.ResponseDiagnosticsProcessor;
import com.azure.spring.data.cosmos.exception.IllegalQueryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class CosmosUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CosmosUtils.class);

    public static <T> void fillAndProcessResponseDiagnostics(ResponseDiagnosticsProcessor responseDiagnosticsProcessor, CosmosDiagnostics cosmosDiagnostics, FeedResponse<T> feedResponse) {
        if (responseDiagnosticsProcessor == null) {
            return;
        }
        ResponseDiagnostics.CosmosResponseStatistics cosmosResponseStatistics = null;
        if (feedResponse != null) {
            cosmosResponseStatistics = new ResponseDiagnostics.CosmosResponseStatistics(feedResponse);
        }
        if (cosmosDiagnostics == null && cosmosResponseStatistics == null) {
            LOGGER.debug("Empty response diagnostics");
            return;
        }
        ResponseDiagnostics responseDiagnostics = new ResponseDiagnostics(cosmosDiagnostics, cosmosResponseStatistics);
        responseDiagnosticsProcessor.processResponseDiagnostics(responseDiagnostics);
    }

    public static String getStringIDValue(Object idValue) {
        Assert.notNull((Object)idValue, (String)"id should not be null");
        if (idValue instanceof String) {
            Assert.hasText((String)idValue.toString(), (String)"id should not be empty or only whitespaces.");
            return (String)idValue;
        }
        if (idValue instanceof Integer) {
            return Integer.toString((Integer)idValue);
        }
        if (idValue instanceof Long) {
            return Long.toString((Long)idValue);
        }
        throw new IllegalQueryException("Type of id field must be String or Integer or Long");
    }
}

