/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.exception;

import com.azure.cosmos.CosmosException;
import com.azure.spring.data.cosmos.exception.CosmosAccessException;
import org.springframework.util.StringUtils;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public class CosmosExceptionUtils {
    public static <T> Mono<T> exceptionHandler(String message, Throwable throwable) {
        if (StringUtils.isEmpty((Object)message)) {
            message = "Failed to access cosmos db database";
        }
        Throwable unwrappedThrowable = Exceptions.unwrap((Throwable)throwable);
        throw new CosmosAccessException(message, unwrappedThrowable);
    }

    public static <T> Mono<T> findAPIExceptionHandler(String message, Throwable throwable) {
        CosmosException cosmosClientException;
        Throwable unwrappedThrowable = Exceptions.unwrap((Throwable)throwable);
        if (unwrappedThrowable instanceof CosmosException && (cosmosClientException = (CosmosException)unwrappedThrowable).getStatusCode() == 404) {
            return Mono.empty();
        }
        return CosmosExceptionUtils.exceptionHandler(message, unwrappedThrowable);
    }
}

