/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.core;

import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosContainerResponse;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.spring.data.cosmos.core.convert.MappingCosmosConverter;
import com.azure.spring.data.cosmos.core.query.CosmosQuery;
import com.azure.spring.data.cosmos.repository.support.CosmosEntityInformation;
import org.springframework.data.domain.Sort;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveCosmosOperations {
    public String getContainerName(Class<?> var1);

    public Mono<CosmosContainerResponse> createContainerIfNotExists(CosmosEntityInformation<?, ?> var1);

    public Mono<CosmosContainerProperties> getContainerProperties(String var1);

    public Mono<CosmosContainerProperties> replaceContainerProperties(String var1, CosmosContainerProperties var2);

    public <T> Flux<T> findAll(String var1, Class<T> var2);

    public <T> Flux<T> findAll(Class<T> var1);

    public <T> Flux<T> findAll(PartitionKey var1, Class<T> var2);

    public <T> Mono<T> findById(Object var1, Class<T> var2);

    public <T> Mono<T> findById(String var1, Object var2, Class<T> var3);

    public <T> Mono<T> findById(Object var1, Class<T> var2, PartitionKey var3);

    public <T> Mono<T> insert(T var1, PartitionKey var2);

    public <T> Mono<T> insert(String var1, Object var2, PartitionKey var3);

    public <T> Mono<T> insert(String var1, T var2);

    public <T> Mono<T> upsert(T var1);

    public <T> Mono<T> upsert(String var1, T var2);

    public Mono<Void> deleteById(String var1, Object var2, PartitionKey var3);

    public <T> Mono<Void> deleteEntity(String var1, T var2);

    public Mono<Void> deleteAll(String var1, Class<?> var2);

    public void deleteContainer(String var1);

    public <T> Flux<T> delete(CosmosQuery var1, Class<T> var2, String var3);

    public <T> Flux<T> find(CosmosQuery var1, Class<T> var2, String var3);

    public Mono<Boolean> exists(CosmosQuery var1, Class<?> var2, String var3);

    public Mono<Boolean> existsById(Object var1, Class<?> var2, String var3);

    public Mono<Long> count(String var1);

    public Mono<Long> count(CosmosQuery var1, String var2);

    public Mono<Long> count(SqlQuerySpec var1, String var2);

    public MappingCosmosConverter getConverter();

    public <T> Flux<T> runQuery(SqlQuerySpec var1, Class<?> var2, Class<T> var3);

    public <T> Flux<T> runQuery(SqlQuerySpec var1, Sort var2, Class<?> var3, Class<T> var4);
}

