/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.repository.support;

import com.azure.cosmos.models.CompositePath;
import com.azure.cosmos.models.ExcludedPath;
import com.azure.cosmos.models.IncludedPath;
import com.azure.cosmos.models.IndexingMode;
import com.azure.cosmos.models.IndexingPolicy;
import com.azure.spring.data.cosmos.Constants;
import com.azure.spring.data.cosmos.common.ExpressionResolver;
import com.azure.spring.data.cosmos.common.Memoizer;
import com.azure.spring.data.cosmos.core.mapping.CompositeIndex;
import com.azure.spring.data.cosmos.core.mapping.CompositeIndexPath;
import com.azure.spring.data.cosmos.core.mapping.Container;
import com.azure.spring.data.cosmos.core.mapping.CosmosIndexingPolicy;
import com.azure.spring.data.cosmos.core.mapping.GeneratedValue;
import com.azure.spring.data.cosmos.core.mapping.PartitionKey;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Version;
import org.springframework.data.domain.Persistable;
import org.springframework.data.repository.core.support.AbstractEntityInformation;
import org.springframework.lang.NonNull;
import org.springframework.util.ReflectionUtils;

public class CosmosEntityInformation<T, ID>
extends AbstractEntityInformation<T, ID> {
    private static final Function<Class<?>, CosmosEntityInformation<?, ?>> ENTITY_INFORMATION_CREATOR = Memoizer.memoize(CosmosEntityInformation::getCosmosEntityInformation);
    private final Field id;
    private final Field partitionKeyField;
    private final Field versionField;
    private final String containerName;
    private final String partitionKeyPath;
    private final Integer requestUnit;
    private final Integer timeToLive;
    private final IndexingPolicy indexingPolicy;
    private final boolean autoCreateContainer;
    private final boolean autoGenerateId;
    private final boolean persitable;
    private final boolean autoScale;
    private final boolean isIndexingPolicySpecified;

    private static CosmosEntityInformation<?, ?> getCosmosEntityInformation(Class<?> domainClass) {
        return new CosmosEntityInformation(domainClass);
    }

    public static CosmosEntityInformation<?, ?> getInstance(Class<?> domainClass) {
        return ENTITY_INFORMATION_CREATOR.apply(domainClass);
    }

    public CosmosEntityInformation(Class<T> domainType) {
        super(domainType);
        this.id = this.getIdField(domainType);
        ReflectionUtils.makeAccessible((Field)this.id);
        this.autoGenerateId = this.isIdFieldAnnotatedWithGeneratedValue(this.id);
        this.containerName = this.getContainerName(domainType);
        this.partitionKeyPath = this.getPartitionKeyPathAnnotationValue(domainType);
        this.partitionKeyField = this.getPartitionKeyField(domainType);
        if (this.partitionKeyField != null) {
            ReflectionUtils.makeAccessible((Field)this.partitionKeyField);
        }
        this.versionField = this.getVersionedField(domainType);
        if (this.versionField != null) {
            ReflectionUtils.makeAccessible((Field)this.versionField);
        }
        this.requestUnit = this.getRequestUnit(domainType);
        this.timeToLive = this.getTimeToLive(domainType);
        this.indexingPolicy = this.getIndexingPolicy(domainType);
        this.autoCreateContainer = this.getIsAutoCreateContainer(domainType);
        this.persitable = Persistable.class.isAssignableFrom(domainType);
        this.autoScale = this.getIsAutoScale(domainType);
        this.isIndexingPolicySpecified = this.isIndexingPolicySpecified(domainType);
    }

    public boolean isNew(T entity) {
        if (this.persitable) {
            return ((Persistable)entity).isNew();
        }
        return super.isNew(entity);
    }

    public ID getId(T entity) {
        return (ID)ReflectionUtils.getField((Field)this.id, entity);
    }

    public Field getIdField() {
        return this.id;
    }

    public String getIdFieldName() {
        return this.id.getName();
    }

    public boolean shouldGenerateId() {
        return this.autoGenerateId;
    }

    public Class<ID> getIdType() {
        return this.id.getType();
    }

    public String getContainerName() {
        return this.containerName;
    }

    public Integer getRequestUnit() {
        return this.requestUnit;
    }

    public Integer getTimeToLive() {
        return this.timeToLive;
    }

    @NonNull
    public IndexingPolicy getIndexingPolicy() {
        return this.indexingPolicy;
    }

    public boolean isVersioned() {
        return this.versionField != null;
    }

    public String getVersionFieldName() {
        return this.versionField == null ? null : this.versionField.getName();
    }

    public String getPartitionKeyPath() {
        if (this.partitionKeyField == null) {
            return this.partitionKeyPath == null ? "/null" : this.partitionKeyPath;
        }
        PartitionKey partitionKey = this.partitionKeyField.getAnnotation(PartitionKey.class);
        return partitionKey.value().equals("") ? "/" + this.partitionKeyField.getName() : "/" + partitionKey.value();
    }

    public String getVersionFieldValue(Object entity) {
        return this.versionField == null ? null : (String)ReflectionUtils.getField((Field)this.versionField, (Object)entity);
    }

    public Object getPartitionKeyFieldValue(T entity) {
        return this.partitionKeyField == null ? null : ReflectionUtils.getField((Field)this.partitionKeyField, entity);
    }

    public String getPartitionKeyFieldName() {
        return this.partitionKeyField == null ? null : this.partitionKeyField.getName();
    }

    public boolean isAutoCreateContainer() {
        return this.autoCreateContainer;
    }

    public boolean isAutoScale() {
        return this.autoScale;
    }

    public boolean isIndexingPolicySpecified() {
        return this.isIndexingPolicySpecified;
    }

    private boolean isIndexingPolicySpecified(Class<?> domainType) {
        return domainType.getAnnotation(CosmosIndexingPolicy.class) != null;
    }

    private IndexingPolicy getIndexingPolicy(Class<?> domainType) {
        IndexingPolicy policy = new IndexingPolicy();
        policy.setAutomatic(this.getIndexingPolicyAutomatic(domainType).booleanValue());
        policy.setIndexingMode(this.getIndexingPolicyMode(domainType));
        policy.setIncludedPaths(this.getIndexingPolicyIncludePaths(domainType));
        policy.setExcludedPaths(this.getIndexingPolicyExcludePaths(domainType));
        policy.setCompositeIndexes(this.getIndexingPolicyCompositeIndexes(domainType));
        return policy;
    }

    private Field getIdField(Class<?> domainType) {
        Field idField;
        List fields = FieldUtils.getFieldsListWithAnnotation(domainType, Id.class);
        if (fields.isEmpty()) {
            idField = ReflectionUtils.findField((Class)this.getJavaType(), (String)"id");
        } else if (fields.size() == 1) {
            idField = (Field)fields.get(0);
        } else {
            throw new IllegalArgumentException("only one field with @Id annotation!");
        }
        if (idField == null) {
            throw new IllegalArgumentException("domain should contain @Id field or field named id");
        }
        if (idField.getType() != String.class && idField.getType() != Integer.class && idField.getType() != Integer.TYPE && idField.getType() != Long.class && idField.getType() != Long.TYPE && idField.getType() != UUID.class) {
            throw new IllegalArgumentException("type of id field must be String, Integer, Long or UUID");
        }
        return idField;
    }

    private boolean isIdFieldAnnotatedWithGeneratedValue(Field idField) {
        if (this.id.getAnnotation(GeneratedValue.class) != null) {
            if (idField.getType() == String.class) {
                return true;
            }
            throw new IllegalArgumentException("id field must be of type String if GeneratedValue annotation is present");
        }
        return false;
    }

    private String getContainerName(Class<?> domainType) {
        String customContainerName = domainType.getSimpleName();
        Container annotation = domainType.getAnnotation(Container.class);
        if (annotation != null && !annotation.containerName().isEmpty()) {
            customContainerName = ExpressionResolver.resolveExpression(annotation.containerName());
        }
        return customContainerName;
    }

    private String getPartitionKeyPathAnnotationValue(Class<?> domainType) {
        Container annotation = domainType.getAnnotation(Container.class);
        if (annotation != null && !annotation.partitionKeyPath().isEmpty()) {
            return annotation.partitionKeyPath();
        }
        return null;
    }

    private Field getPartitionKeyField(Class<?> domainType) {
        Field partitionKey = null;
        List fields = FieldUtils.getFieldsListWithAnnotation(domainType, PartitionKey.class);
        if (fields.size() == 1) {
            partitionKey = (Field)fields.get(0);
        } else if (fields.size() > 1) {
            throw new IllegalArgumentException("Azure Cosmos DB supports only one partition key, only one field with @PartitionKey annotation!");
        }
        return partitionKey;
    }

    private Integer getRequestUnit(Class<?> domainType) {
        Integer ru = null;
        Container annotation = domainType.getAnnotation(Container.class);
        if (annotation != null && annotation.ru() != null && !annotation.ru().isEmpty()) {
            ru = Integer.parseInt(annotation.ru());
        }
        return ru;
    }

    private Integer getTimeToLive(Class<T> domainType) {
        Integer ttl = -1;
        Container annotation = domainType.getAnnotation(Container.class);
        if (annotation != null) {
            ttl = annotation.timeToLive();
        }
        return ttl;
    }

    private Boolean getIndexingPolicyAutomatic(Class<?> domainType) {
        Boolean isAutomatic = true;
        CosmosIndexingPolicy annotation = domainType.getAnnotation(CosmosIndexingPolicy.class);
        if (annotation != null) {
            isAutomatic = annotation.automatic();
        }
        return isAutomatic;
    }

    private IndexingMode getIndexingPolicyMode(Class<?> domainType) {
        IndexingMode mode = Constants.DEFAULT_INDEXING_POLICY_MODE;
        CosmosIndexingPolicy annotation = domainType.getAnnotation(CosmosIndexingPolicy.class);
        if (annotation != null) {
            mode = annotation.mode();
        }
        return mode;
    }

    private List<IncludedPath> getIndexingPolicyIncludePaths(Class<?> domainType) {
        String[] rawPaths;
        ArrayList<IncludedPath> pathArrayList = new ArrayList<IncludedPath>();
        CosmosIndexingPolicy annotation = domainType.getAnnotation(CosmosIndexingPolicy.class);
        if (annotation == null || annotation.includePaths().length == 0) {
            return null;
        }
        for (String path : rawPaths = annotation.includePaths()) {
            pathArrayList.add(new IncludedPath(path));
        }
        return pathArrayList;
    }

    private List<ExcludedPath> getIndexingPolicyExcludePaths(Class<?> domainType) {
        String[] rawPaths;
        ArrayList<ExcludedPath> pathArrayList = new ArrayList<ExcludedPath>();
        CosmosIndexingPolicy annotation = domainType.getAnnotation(CosmosIndexingPolicy.class);
        if (annotation == null || annotation.excludePaths().length == 0) {
            return null;
        }
        for (String path : rawPaths = annotation.excludePaths()) {
            pathArrayList.add(new ExcludedPath(path));
        }
        return pathArrayList;
    }

    private List<List<CompositePath>> getIndexingPolicyCompositeIndexes(Class<?> domainType) {
        CompositeIndex[] compositeIndexes;
        ArrayList<List<CompositePath>> compositePathList = new ArrayList<List<CompositePath>>();
        CosmosIndexingPolicy annotation = domainType.getAnnotation(CosmosIndexingPolicy.class);
        if (annotation == null || annotation.compositeIndexes().length == 0) {
            return Collections.emptyList();
        }
        for (CompositeIndex index : compositeIndexes = annotation.compositeIndexes()) {
            ArrayList<CompositePath> paths = new ArrayList<CompositePath>();
            compositePathList.add(paths);
            for (CompositeIndexPath path : index.paths()) {
                CompositePath compositePath = new CompositePath();
                compositePath.setPath(path.path());
                compositePath.setOrder(path.order());
                paths.add(compositePath);
            }
        }
        return compositePathList;
    }

    private Field getVersionedField(Class<T> domainClass) {
        Field version = null;
        List fields = FieldUtils.getFieldsListWithAnnotation(domainClass, Version.class);
        if (fields.size() == 1) {
            version = (Field)fields.get(0);
        } else if (fields.size() > 1) {
            throw new IllegalArgumentException("Azure Cosmos DB supports only one field with @Version annotation!");
        }
        if (version != null && version.getType() != String.class) {
            throw new IllegalArgumentException("type of Version field must be String");
        }
        return version;
    }

    private boolean getIsAutoCreateContainer(Class<T> domainType) {
        Container annotation = domainType.getAnnotation(Container.class);
        boolean autoCreateContainer = true;
        if (annotation != null) {
            autoCreateContainer = annotation.autoCreateContainer();
        }
        return autoCreateContainer;
    }

    private boolean getIsAutoScale(Class<T> domainType) {
        Container annotation = domainType.getAnnotation(Container.class);
        boolean autoScale = false;
        if (annotation != null) {
            autoScale = annotation.autoScale();
        }
        return autoScale;
    }
}

