/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.springframework.lang.NonNull;

public final class PropertyLoader {
    private static final String PROJECT_PROPERTY_FILE = "/META-INF/azure-spring-data-cosmos.properties";
    private static final String APPLICATION_PROPERTY_FILE = "/application.properties";
    private static final String APPLICATION_YML_FILE = "/application.yml";

    private PropertyLoader() {
    }

    public static String getProjectVersion() {
        return PropertyLoader.getPropertyByName("project.version", PROJECT_PROPERTY_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPropertyByName(@NonNull String name, @NonNull String filename) {
        Properties properties = new Properties();
        InputStream inputStream = PropertyLoader.class.getResourceAsStream(filename);
        if (inputStream == null) {
            return null;
        }
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return properties.getProperty(name);
    }
}

