/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.core.mapping;

import com.azure.spring.data.cosmos.core.convert.MappingCosmosConverter;
import com.azure.spring.data.cosmos.core.mapping.CosmosPersistentEntity;
import com.azure.spring.data.cosmos.core.mapping.CosmosPersistentProperty;
import com.azure.spring.data.cosmos.core.mapping.EnableCosmosAuditing;
import java.lang.annotation.Annotation;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.auditing.config.AuditingBeanDefinitionRegistrarSupport;
import org.springframework.data.auditing.config.AuditingConfiguration;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.util.Assert;

class CosmosAuditingRegistrar
extends AuditingBeanDefinitionRegistrarSupport {
    CosmosAuditingRegistrar() {
    }

    protected Class<? extends Annotation> getAnnotation() {
        return EnableCosmosAuditing.class;
    }

    protected String getAuditingHandlerBeanName() {
        return "cosmosAuditingHandler";
    }

    protected BeanDefinitionBuilder getAuditHandlerBeanDefinitionBuilder(AuditingConfiguration configuration) {
        Assert.notNull((Object)configuration, (String)"AuditingConfiguration must not be null!");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(IsNewAwareAuditingHandler.class);
        BeanDefinitionBuilder definition = BeanDefinitionBuilder.genericBeanDefinition(CosmosMappingContextLookup.class);
        definition.setAutowireMode(3);
        builder.addConstructorArgValue((Object)definition.getBeanDefinition());
        return this.configureDefaultAuditHandlerAttributes(configuration, builder);
    }

    protected void registerAuditListenerBeanDefinition(BeanDefinition auditingHandlerDefinition, BeanDefinitionRegistry registry) {
    }

    static class CosmosMappingContextLookup
    implements FactoryBean<MappingContext<? extends CosmosPersistentEntity<?>, CosmosPersistentProperty>> {
        private final MappingCosmosConverter converter;

        CosmosMappingContextLookup(MappingCosmosConverter converter) {
            this.converter = converter;
        }

        public MappingContext<? extends CosmosPersistentEntity<?>, CosmosPersistentProperty> getObject() {
            return this.converter.getMappingContext();
        }

        public Class<?> getObjectType() {
            return MappingContext.class;
        }

        public boolean isSingleton() {
            return true;
        }
    }
}

