/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.repository.support;

import com.azure.cosmos.CosmosException;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosContainerResponse;
import com.azure.cosmos.models.CosmosPatchItemRequestOptions;
import com.azure.cosmos.models.CosmosPatchOperations;
import com.azure.cosmos.models.PartitionKey;
import com.azure.spring.data.cosmos.core.ReactiveCosmosOperations;
import com.azure.spring.data.cosmos.core.query.CosmosQuery;
import com.azure.spring.data.cosmos.core.query.Criteria;
import com.azure.spring.data.cosmos.core.query.CriteriaType;
import com.azure.spring.data.cosmos.repository.ReactiveCosmosRepository;
import com.azure.spring.data.cosmos.repository.support.CosmosEntityInformation;
import com.azure.spring.data.cosmos.repository.support.IndexPolicyCompareService;
import java.io.Serializable;
import org.reactivestreams.Publisher;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SimpleReactiveCosmosRepository<T, K extends Serializable>
implements ReactiveCosmosRepository<T, K> {
    private final CosmosEntityInformation<T, K> entityInformation;
    private final ReactiveCosmosOperations cosmosOperations;

    public SimpleReactiveCosmosRepository(CosmosEntityInformation<T, K> metadata, ReactiveCosmosOperations reactiveCosmosOperations) {
        CosmosContainerProperties currentProperties;
        this.cosmosOperations = reactiveCosmosOperations;
        this.entityInformation = metadata;
        if (this.entityInformation.isAutoCreateContainer()) {
            this.createContainerIfNotExists();
        }
        if ((currentProperties = this.getContainerProperties()) != null && this.entityInformation.isIndexingPolicySpecified() && IndexPolicyCompareService.policyNeedsUpdate(currentProperties.getIndexingPolicy(), this.entityInformation.getIndexingPolicy())) {
            currentProperties.setIndexingPolicy(this.entityInformation.getIndexingPolicy());
            this.replaceContainerProperties(currentProperties);
        }
    }

    private CosmosContainerProperties getContainerProperties() {
        try {
            return (CosmosContainerProperties)this.cosmosOperations.getContainerProperties(this.entityInformation.getContainerName()).block();
        }
        catch (CosmosException ex) {
            if (ex.getStatusCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    private CosmosContainerProperties replaceContainerProperties(CosmosContainerProperties properties) {
        return (CosmosContainerProperties)this.cosmosOperations.replaceContainerProperties(this.entityInformation.getContainerName(), properties).block();
    }

    private CosmosContainerResponse createContainerIfNotExists() {
        return (CosmosContainerResponse)this.cosmosOperations.createContainerIfNotExists(this.entityInformation).block();
    }

    public Flux<T> findAll(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        CosmosQuery query = new CosmosQuery(Criteria.getInstance(CriteriaType.ALL)).with(sort);
        return this.cosmosOperations.find(query, this.entityInformation.getJavaType(), this.entityInformation.getContainerName());
    }

    @Override
    public Flux<T> findAll(PartitionKey partitionKey) {
        return this.cosmosOperations.findAll(partitionKey, this.entityInformation.getJavaType());
    }

    public <S extends T> Mono<S> save(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        if (this.entityInformation.isNew(entity)) {
            return this.cosmosOperations.insert(this.entityInformation.getContainerName(), entity);
        }
        return this.cosmosOperations.upsert(this.entityInformation.getContainerName(), entity);
    }

    @Override
    public <S extends T> Mono<S> save(K id, PartitionKey partitionKey, Class<S> domainType, CosmosPatchOperations patchOperations) {
        Assert.notNull(id, (String)"entity must not be null");
        return this.cosmosOperations.patch(id, partitionKey, domainType, patchOperations);
    }

    @Override
    public <S extends T> Mono<S> save(K id, PartitionKey partitionKey, Class<S> domainType, CosmosPatchOperations patchOperations, CosmosPatchItemRequestOptions options) {
        Assert.notNull(id, (String)"entity must not be null");
        return this.cosmosOperations.patch(id, partitionKey, domainType, patchOperations, options);
    }

    public <S extends T> Flux<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        return Flux.fromIterable(entities).flatMap(this::save);
    }

    public <S extends T> Flux<S> saveAll(Publisher<S> entityStream) {
        Assert.notNull(entityStream, (String)"The given Publisher of entities must not be null!");
        return Flux.from(entityStream).flatMap(this::save);
    }

    public Mono<T> findById(K id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.cosmosOperations.findById(this.entityInformation.getContainerName(), id, this.entityInformation.getJavaType());
    }

    public Mono<T> findById(Publisher<K> publisher) {
        Assert.notNull(publisher, (String)"The given id must not be null!");
        return Mono.from(publisher).flatMap(id -> this.cosmosOperations.findById(this.entityInformation.getContainerName(), id, this.entityInformation.getJavaType()));
    }

    @Override
    public Mono<T> findById(K id, PartitionKey partitionKey) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.cosmosOperations.findById(id, this.entityInformation.getJavaType(), partitionKey);
    }

    public Mono<Boolean> existsById(K id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.cosmosOperations.existsById(id, this.entityInformation.getJavaType(), this.entityInformation.getContainerName());
    }

    public Mono<Boolean> existsById(Publisher<K> publisher) {
        Assert.notNull(publisher, (String)"The given id must not be null!");
        return Mono.from(publisher).flatMap(id -> this.cosmosOperations.existsById(id, this.entityInformation.getJavaType(), this.entityInformation.getContainerName()));
    }

    public Flux<T> findAll() {
        return this.cosmosOperations.findAll(this.entityInformation.getContainerName(), this.entityInformation.getJavaType());
    }

    public Flux<T> findAllById(Iterable<K> ids) {
        Assert.notNull(ids, (String)"Iterable ids should not be null");
        throw new UnsupportedOperationException();
    }

    public Flux<T> findAllById(Publisher<K> ids) {
        Assert.notNull(ids, (String)"The given Publisher of Id's must not be null!");
        throw new UnsupportedOperationException();
    }

    public Mono<Long> count() {
        return this.cosmosOperations.count(this.entityInformation.getContainerName());
    }

    public Mono<Void> deleteById(K id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.cosmosOperations.deleteById(this.entityInformation.getContainerName(), id, null);
    }

    public Mono<Void> deleteById(Publisher<K> publisher) {
        Assert.notNull(publisher, (String)"Id must not be null!");
        return Mono.from(publisher).flatMap(id -> this.cosmosOperations.deleteById(this.entityInformation.getContainerName(), id, null)).then();
    }

    @Override
    public Mono<Void> deleteById(K id, PartitionKey partitionKey) {
        Assert.notNull(id, (String)"Id must not be null!");
        Assert.notNull((Object)partitionKey, (String)"PartitionKey must not be null!");
        return this.cosmosOperations.deleteById(this.entityInformation.getContainerName(), id, partitionKey);
    }

    public Mono<Void> delete(@NonNull T entity) {
        Assert.notNull(entity, (String)"entity to be deleted must not be null!");
        return this.cosmosOperations.deleteEntity(this.entityInformation.getContainerName(), entity);
    }

    public Mono<Void> deleteAllById(Iterable<? extends K> ids) {
        Assert.notNull(ids, (String)"The given Iterable of ids must not be null!");
        return Flux.fromIterable(ids).flatMap(this::deleteById).then();
    }

    public Mono<Void> deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        return Flux.fromIterable(entities).flatMap(this::delete).then();
    }

    public Mono<Void> deleteAll(Publisher<? extends T> entityStream) {
        Assert.notNull(entityStream, (String)"The given Publisher of entities must not be null!");
        return Flux.from(entityStream).map(arg_0 -> this.entityInformation.getRequiredId(arg_0)).flatMap(this::deleteById).then();
    }

    public Mono<Void> deleteAll() {
        return this.cosmosOperations.deleteAll(this.entityInformation.getContainerName(), this.entityInformation.getJavaType());
    }
}

