/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.core;

import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosContainerResponse;
import com.azure.cosmos.models.CosmosDatabaseResponse;
import com.azure.cosmos.models.CosmosItemRequestOptions;
import com.azure.cosmos.models.CosmosItemResponse;
import com.azure.cosmos.models.CosmosPatchItemRequestOptions;
import com.azure.cosmos.models.CosmosPatchOperations;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.models.ThroughputProperties;
import com.azure.cosmos.models.UniqueKeyPolicy;
import com.azure.spring.data.cosmos.CosmosFactory;
import com.azure.spring.data.cosmos.common.CosmosUtils;
import com.azure.spring.data.cosmos.config.CosmosConfig;
import com.azure.spring.data.cosmos.config.DatabaseThroughputConfig;
import com.azure.spring.data.cosmos.core.CosmosOperations;
import com.azure.spring.data.cosmos.core.ResponseDiagnosticsProcessor;
import com.azure.spring.data.cosmos.core.convert.MappingCosmosConverter;
import com.azure.spring.data.cosmos.core.generator.CountQueryGenerator;
import com.azure.spring.data.cosmos.core.generator.FindQuerySpecGenerator;
import com.azure.spring.data.cosmos.core.generator.NativeQueryGenerator;
import com.azure.spring.data.cosmos.core.mapping.event.AfterLoadEvent;
import com.azure.spring.data.cosmos.core.mapping.event.CosmosMappingEvent;
import com.azure.spring.data.cosmos.core.query.CosmosPageImpl;
import com.azure.spring.data.cosmos.core.query.CosmosPageRequest;
import com.azure.spring.data.cosmos.core.query.CosmosQuery;
import com.azure.spring.data.cosmos.core.query.CosmosSliceImpl;
import com.azure.spring.data.cosmos.core.query.Criteria;
import com.azure.spring.data.cosmos.core.query.CriteriaType;
import com.azure.spring.data.cosmos.exception.CosmosExceptionUtils;
import com.azure.spring.data.cosmos.repository.support.CosmosEntityInformation;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class CosmosTemplate
implements CosmosOperations,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(CosmosTemplate.class);
    private final MappingCosmosConverter mappingCosmosConverter;
    private final IsNewAwareAuditingHandler cosmosAuditingHandler;
    private final CosmosFactory cosmosFactory;
    private final ResponseDiagnosticsProcessor responseDiagnosticsProcessor;
    private final boolean queryMetricsEnabled;
    private final int maxDegreeOfParallelism;
    private final int maxBufferedItemCount;
    private final int responseContinuationTokenLimitInKb;
    private final DatabaseThroughputConfig databaseThroughputConfig;
    private ApplicationContext applicationContext;

    public CosmosTemplate(CosmosAsyncClient client, String databaseName, CosmosConfig cosmosConfig, MappingCosmosConverter mappingCosmosConverter, IsNewAwareAuditingHandler cosmosAuditingHandler) {
        this(new CosmosFactory(client, databaseName), cosmosConfig, mappingCosmosConverter, cosmosAuditingHandler);
    }

    public CosmosTemplate(CosmosAsyncClient client, String databaseName, CosmosConfig cosmosConfig, MappingCosmosConverter mappingCosmosConverter) {
        this(new CosmosFactory(client, databaseName), cosmosConfig, mappingCosmosConverter, null);
    }

    public CosmosTemplate(CosmosFactory cosmosFactory, CosmosConfig cosmosConfig, MappingCosmosConverter mappingCosmosConverter, IsNewAwareAuditingHandler cosmosAuditingHandler) {
        Assert.notNull((Object)cosmosFactory, (String)"CosmosFactory must not be null!");
        Assert.notNull((Object)mappingCosmosConverter, (String)"MappingCosmosConverter must not be null!");
        this.mappingCosmosConverter = mappingCosmosConverter;
        this.cosmosAuditingHandler = cosmosAuditingHandler;
        this.cosmosFactory = cosmosFactory;
        this.responseDiagnosticsProcessor = cosmosConfig.getResponseDiagnosticsProcessor();
        this.queryMetricsEnabled = cosmosConfig.isQueryMetricsEnabled();
        this.maxDegreeOfParallelism = cosmosConfig.getMaxDegreeOfParallelism();
        this.maxBufferedItemCount = cosmosConfig.getMaxBufferedItemCount();
        this.responseContinuationTokenLimitInKb = cosmosConfig.getResponseContinuationTokenLimitInKb();
        this.databaseThroughputConfig = cosmosConfig.getDatabaseThroughputConfig();
    }

    public CosmosTemplate(CosmosFactory cosmosFactory, CosmosConfig cosmosConfig, MappingCosmosConverter mappingCosmosConverter) {
        this(cosmosFactory, cosmosConfig, mappingCosmosConverter, null);
    }

    private String getDatabaseName() {
        return this.cosmosFactory.getDatabaseName();
    }

    private CosmosAsyncClient getCosmosAsyncClient() {
        return this.cosmosFactory.getCosmosAsyncClient();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public <T> T insert(T objectToSave, PartitionKey partitionKey) {
        return this.insert(this.getContainerName(objectToSave.getClass()), objectToSave, partitionKey);
    }

    @Override
    public <T> T insert(String containerName, T objectToSave) {
        return this.insert(containerName, objectToSave, null);
    }

    @Override
    public <T> T insert(String containerName, T objectToSave, PartitionKey partitionKey) {
        Assert.hasText((String)containerName, (String)"containerName should not be null, empty or only whitespaces");
        Assert.notNull(objectToSave, (String)"objectToSave should not be null");
        Class<?> domainType = objectToSave.getClass();
        containerName = this.getContainerName(domainType);
        this.markAuditedIfConfigured(objectToSave);
        this.generateIdIfNullAndAutoGenerationEnabled(objectToSave, domainType);
        JsonNode originalItem = this.mappingCosmosConverter.writeJsonNode(objectToSave);
        LOGGER.debug("execute createItem in database {} container {}", (Object)this.getDatabaseName(), (Object)containerName);
        CosmosItemRequestOptions options = new CosmosItemRequestOptions();
        CosmosItemResponse response = (CosmosItemResponse)this.getCosmosAsyncClient().getDatabase(this.getDatabaseName()).getContainer(containerName).createItem((Object)originalItem, partitionKey, options).publishOn(Schedulers.parallel()).doOnNext(cosmosItemResponse -> CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosItemResponse.getDiagnostics(), null)).onErrorResume(throwable -> CosmosExceptionUtils.exceptionHandler("Failed to insert item", throwable, this.responseDiagnosticsProcessor)).block();
        assert (response != null);
        return (T)this.toDomainObject(domainType, (JsonNode)response.getItem());
    }

    @Override
    public <T> T patch(Object id, PartitionKey partitionKey, Class<T> domainType, CosmosPatchOperations patchOperations) {
        return this.patch(id, partitionKey, domainType, patchOperations, null);
    }

    @Override
    public <T> T patch(Object id, PartitionKey partitionKey, Class<T> domainType, CosmosPatchOperations patchOperations, CosmosPatchItemRequestOptions options) {
        Assert.notNull((Object)patchOperations, (String)"expected non-null cosmosPatchOperations");
        String containerName = this.getContainerName(domainType);
        Assert.notNull((Object)id, (String)"id should not be null");
        Assert.notNull((Object)partitionKey, (String)"partitionKey should not be null, empty or only whitespaces");
        Assert.notNull((Object)patchOperations, (String)"patchOperations should not be null, empty or only whitespaces");
        LOGGER.debug("execute patchItem in database {} container {}", (Object)this.getDatabaseName(), (Object)containerName);
        if (options == null) {
            options = new CosmosPatchItemRequestOptions();
        }
        CosmosItemResponse response = (CosmosItemResponse)this.getCosmosAsyncClient().getDatabase(this.getDatabaseName()).getContainer(containerName).patchItem(id.toString(), partitionKey, patchOperations, options, JsonNode.class).publishOn(Schedulers.parallel()).doOnNext(cosmosItemResponse -> CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosItemResponse.getDiagnostics(), null)).onErrorResume(throwable -> CosmosExceptionUtils.exceptionHandler("Failed to patch item", throwable, this.responseDiagnosticsProcessor)).block();
        assert (response != null);
        return this.toDomainObject(domainType, (JsonNode)response.getItem());
    }

    private <T> void generateIdIfNullAndAutoGenerationEnabled(T originalItem, Class<?> type) {
        CosmosEntityInformation<?, ?> entityInfo = CosmosEntityInformation.getInstance(type);
        if (entityInfo.shouldGenerateId() && ReflectionUtils.getField((Field)entityInfo.getIdField(), originalItem) == null) {
            ReflectionUtils.setField((Field)entityInfo.getIdField(), originalItem, (Object)UUID.randomUUID().toString());
        }
    }

    @Override
    public <T> T findById(Object id, Class<T> domainType) {
        Assert.notNull(domainType, (String)"domainType should not be null");
        return this.findById(this.getContainerName(domainType), id, domainType);
    }

    @Override
    public <T> T findById(Object id, Class<T> domainType, PartitionKey partitionKey) {
        Assert.notNull(domainType, (String)"domainType should not be null");
        Assert.notNull((Object)partitionKey, (String)"partitionKey should not be null");
        String idToQuery = CosmosUtils.getStringIDValue(id);
        String containerName = this.getContainerName(domainType);
        return (T)this.getCosmosAsyncClient().getDatabase(this.getDatabaseName()).getContainer(containerName).readItem(idToQuery, partitionKey, JsonNode.class).publishOn(Schedulers.parallel()).flatMap(cosmosItemResponse -> {
            CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosItemResponse.getDiagnostics(), null);
            return Mono.justOrEmpty(this.emitOnLoadEventAndConvertToDomainObject(domainType, containerName, (JsonNode)cosmosItemResponse.getItem()));
        }).onErrorResume(throwable -> CosmosExceptionUtils.findAPIExceptionHandler("Failed to find item", throwable, this.responseDiagnosticsProcessor)).block();
    }

    @Override
    public <T> T findById(String containerName, Object id, Class<T> domainType) {
        Assert.hasText((String)containerName, (String)"containerName should not be null, empty or only whitespaces");
        Assert.notNull(domainType, (String)"domainType should not be null");
        String finalContainerName = this.getContainerNameOverride(containerName);
        String query = "select * from root where root.id = @ROOT_ID";
        SqlParameter param = new SqlParameter("@ROOT_ID", (Object)CosmosUtils.getStringIDValue(id));
        SqlQuerySpec sqlQuerySpec = new SqlQuerySpec("select * from root where root.id = @ROOT_ID", new SqlParameter[]{param});
        CosmosQueryRequestOptions options = new CosmosQueryRequestOptions();
        options.setQueryMetricsEnabled(this.queryMetricsEnabled);
        options.setMaxDegreeOfParallelism(this.maxDegreeOfParallelism);
        options.setMaxBufferedItemCount(this.maxBufferedItemCount);
        options.setResponseContinuationTokenLimitInKb(this.responseContinuationTokenLimitInKb);
        return (T)this.getCosmosAsyncClient().getDatabase(this.getDatabaseName()).getContainer(finalContainerName).queryItems(sqlQuerySpec, options, JsonNode.class).byPage().publishOn(Schedulers.parallel()).flatMap(cosmosItemFeedResponse -> {
            CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosItemFeedResponse.getCosmosDiagnostics(), cosmosItemFeedResponse);
            return Mono.justOrEmpty(cosmosItemFeedResponse.getResults().stream().map(cosmosItem -> this.emitOnLoadEventAndConvertToDomainObject(domainType, finalContainerName, (JsonNode)cosmosItem)).findFirst());
        }).onErrorResume(throwable -> CosmosExceptionUtils.findAPIExceptionHandler("Failed to find item", throwable, this.responseDiagnosticsProcessor)).blockFirst();
    }

    @Override
    public <T> void upsert(T object) {
        Assert.notNull(object, (String)"Upsert object should not be null");
        this.upsert(this.getContainerName(object.getClass()), object);
    }

    @Override
    public <T> void upsert(String containerName, T object) {
        this.upsertAndReturnEntity(containerName, object);
    }

    @Override
    public <T> T upsertAndReturnEntity(String containerName, T object) {
        Assert.hasText((String)containerName, (String)"containerName should not be null, empty or only whitespaces");
        Assert.notNull(object, (String)"Upsert object should not be null");
        containerName = this.getContainerName(object.getClass());
        this.markAuditedIfConfigured(object);
        JsonNode originalItem = this.mappingCosmosConverter.writeJsonNode(object);
        LOGGER.debug("execute upsert item in database {} container {}", (Object)this.getDatabaseName(), (Object)containerName);
        Class<?> domainType = object.getClass();
        containerName = this.getContainerName(domainType);
        CosmosItemRequestOptions options = new CosmosItemRequestOptions();
        this.applyVersioning(domainType, originalItem, options);
        CosmosItemResponse cosmosItemResponse = (CosmosItemResponse)this.getCosmosAsyncClient().getDatabase(this.getDatabaseName()).getContainer(containerName).upsertItem((Object)originalItem, options).publishOn(Schedulers.parallel()).doOnNext(response -> CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, response.getDiagnostics(), null)).onErrorResume(throwable -> CosmosExceptionUtils.exceptionHandler("Failed to upsert item", throwable, this.responseDiagnosticsProcessor)).block();
        assert (cosmosItemResponse != null);
        return (T)this.toDomainObject(domainType, (JsonNode)cosmosItemResponse.getItem());
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType) {
        Assert.notNull(domainType, (String)"domainType should not be null");
        return this.findAll(this.getContainerName(domainType), domainType);
    }

    @Override
    public <T> Iterable<T> findAll(String containerName, Class<T> domainType) {
        Assert.hasText((String)containerName, (String)"containerName should not be null, empty or only whitespaces");
        Assert.notNull(domainType, (String)"domainType should not be null");
        CosmosQuery query = new CosmosQuery(Criteria.getInstance(CriteriaType.ALL));
        return this.findItems(query, containerName, domainType);
    }

    @Override
    public <T> Iterable<T> findAll(PartitionKey partitionKey, Class<T> domainType) {
        Assert.notNull((Object)partitionKey, (String)"partitionKey should not be null");
        Assert.notNull(domainType, (String)"domainType should not be null");
        String containerName = this.getContainerName(domainType);
        CosmosQueryRequestOptions cosmosQueryRequestOptions = new CosmosQueryRequestOptions();
        cosmosQueryRequestOptions.setPartitionKey(partitionKey);
        cosmosQueryRequestOptions.setQueryMetricsEnabled(this.queryMetricsEnabled);
        cosmosQueryRequestOptions.setMaxDegreeOfParallelism(this.maxDegreeOfParallelism);
        cosmosQueryRequestOptions.setMaxBufferedItemCount(this.maxBufferedItemCount);
        cosmosQueryRequestOptions.setResponseContinuationTokenLimitInKb(this.responseContinuationTokenLimitInKb);
        return this.getCosmosAsyncClient().getDatabase(this.getDatabaseName()).getContainer(containerName).queryItems("SELECT * FROM r", cosmosQueryRequestOptions, JsonNode.class).byPage().publishOn(Schedulers.parallel()).flatMap(cosmosItemFeedResponse -> {
            CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosItemFeedResponse.getCosmosDiagnostics(), cosmosItemFeedResponse);
            return Flux.fromIterable((Iterable)cosmosItemFeedResponse.getResults());
        }).map(jsonNode -> this.emitOnLoadEventAndConvertToDomainObject(domainType, containerName, (JsonNode)jsonNode)).onErrorResume(throwable -> CosmosExceptionUtils.exceptionHandler("Failed to find items", throwable, this.responseDiagnosticsProcessor)).toIterable();
    }

    @Override
    public void deleteAll(@NonNull String containerName, @NonNull Class<?> domainType) {
        Assert.hasText((String)containerName, (String)"containerName should not be null, empty or only whitespaces");
        containerName = this.getContainerName(domainType);
        CosmosQuery query = new CosmosQuery(Criteria.getInstance(CriteriaType.ALL));
        this.delete(query, domainType, containerName);
    }

    @Override
    public void deleteContainer(@NonNull String containerName) {
        Assert.hasText((String)containerName, (String)"containerName should have text.");
        this.getCosmosAsyncClient().getDatabase(this.getDatabaseName()).getContainer(containerName).delete().publishOn(Schedulers.parallel()).doOnNext(response -> CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, response.getDiagnostics(), null)).onErrorResume(throwable -> CosmosExceptionUtils.exceptionHandler("Failed to delete container", throwable, this.responseDiagnosticsProcessor)).block();
    }

    @Override
    public String getContainerName(Class<?> domainType) {
        Assert.notNull(domainType, (String)"domainType should not be null");
        return this.getContainerNameOverride(CosmosEntityInformation.getInstance(domainType).getContainerName());
    }

    public String getContainerNameOverride(String containerName) {
        if (this.cosmosFactory.overrideContainerName() != null) {
            return this.cosmosFactory.overrideContainerName();
        }
        Assert.notNull((Object)containerName, (String)"containerName should not be null");
        return containerName;
    }

    @Override
    public CosmosContainerProperties createContainerIfNotExists(CosmosEntityInformation<?, ?> information) {
        CosmosContainerResponse response = (CosmosContainerResponse)this.createDatabaseIfNotExists().publishOn(Schedulers.parallel()).onErrorResume(throwable -> CosmosExceptionUtils.exceptionHandler("Failed to create database", throwable, this.responseDiagnosticsProcessor)).flatMap(cosmosDatabaseResponse -> {
            Mono cosmosContainerResponseMono;
            CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosDatabaseResponse.getDiagnostics(), null);
            CosmosContainerProperties cosmosContainerProperties = new CosmosContainerProperties(this.getContainerNameOverride(information.getContainerName()), information.getPartitionKeyPath());
            cosmosContainerProperties.setDefaultTimeToLiveInSeconds(information.getTimeToLive());
            cosmosContainerProperties.setIndexingPolicy(information.getIndexingPolicy());
            UniqueKeyPolicy uniqueKeyPolicy = information.getUniqueKeyPolicy();
            if (uniqueKeyPolicy != null) {
                cosmosContainerProperties.setUniqueKeyPolicy(uniqueKeyPolicy);
            }
            CosmosAsyncDatabase cosmosAsyncDatabase = this.getCosmosAsyncClient().getDatabase(cosmosDatabaseResponse.getProperties().getId());
            if (information.getRequestUnit() == null) {
                cosmosContainerResponseMono = cosmosAsyncDatabase.createContainerIfNotExists(cosmosContainerProperties);
            } else {
                ThroughputProperties throughputProperties = information.isAutoScale() ? ThroughputProperties.createAutoscaledThroughput((int)information.getRequestUnit()) : ThroughputProperties.createManualThroughput((int)information.getRequestUnit());
                cosmosContainerResponseMono = cosmosAsyncDatabase.createContainerIfNotExists(cosmosContainerProperties, throughputProperties);
            }
            return cosmosContainerResponseMono.onErrorResume(throwable -> CosmosExceptionUtils.exceptionHandler("Failed to create container", throwable, this.responseDiagnosticsProcessor)).doOnNext(cosmosContainerResponse -> CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosContainerResponse.getDiagnostics(), null));
        }).block();
        assert (response != null);
        return response.getProperties();
    }

    private Mono<CosmosDatabaseResponse> createDatabaseIfNotExists() {
        if (this.databaseThroughputConfig == null) {
            return this.getCosmosAsyncClient().createDatabaseIfNotExists(this.getDatabaseName());
        }
        ThroughputProperties throughputProperties = this.databaseThroughputConfig.isAutoScale() ? ThroughputProperties.createAutoscaledThroughput((int)this.databaseThroughputConfig.getRequestUnits()) : ThroughputProperties.createManualThroughput((int)this.databaseThroughputConfig.getRequestUnits());
        return this.getCosmosAsyncClient().createDatabaseIfNotExists(this.getDatabaseName(), throughputProperties);
    }

    @Override
    public CosmosContainerProperties getContainerProperties(String containerName) {
        containerName = this.getContainerNameOverride(containerName);
        CosmosContainerResponse response = (CosmosContainerResponse)this.getCosmosAsyncClient().getDatabase(this.getDatabaseName()).getContainer(containerName).read().block();
        assert (response != null);
        return response.getProperties();
    }

    @Override
    public CosmosContainerProperties replaceContainerProperties(String containerName, CosmosContainerProperties properties) {
        CosmosContainerResponse response = (CosmosContainerResponse)this.getCosmosAsyncClient().getDatabase(this.getDatabaseName()).getContainer(containerName).replace(properties).block();
        assert (response != null);
        return response.getProperties();
    }

    @Override
    public void deleteById(String containerName, Object id, PartitionKey partitionKey) {
        this.deleteById(containerName, id, partitionKey, new CosmosItemRequestOptions());
    }

    @Override
    public <T> void deleteEntity(String containerName, T entity) {
        containerName = this.getContainerNameOverride(containerName);
        Assert.notNull(entity, (String)"entity to be deleted should not be null");
        Class<?> domainType = entity.getClass();
        JsonNode originalItem = this.mappingCosmosConverter.writeJsonNode(entity);
        CosmosItemRequestOptions options = new CosmosItemRequestOptions();
        this.applyVersioning(entity.getClass(), originalItem, options);
        this.deleteItem(originalItem, containerName, domainType);
    }

    private void deleteById(String containerName, Object id, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        Assert.hasText((String)containerName, (String)"containerName should not be null, empty or only whitespaces");
        containerName = this.getContainerNameOverride(containerName);
        String idToDelete = CosmosUtils.getStringIDValue(id);
        LOGGER.debug("execute deleteById in database {} container {}", (Object)this.getDatabaseName(), (Object)containerName);
        if (partitionKey == null) {
            partitionKey = PartitionKey.NONE;
        }
        this.getCosmosAsyncClient().getDatabase(this.getDatabaseName()).getContainer(containerName).deleteItem(idToDelete, partitionKey, options).publishOn(Schedulers.parallel()).doOnNext(response -> CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, response.getDiagnostics(), null)).onErrorResume(throwable -> CosmosExceptionUtils.exceptionHandler("Failed to delete item", throwable, this.responseDiagnosticsProcessor)).block();
    }

    @Override
    public <T, ID> Iterable<T> findByIds(Iterable<ID> ids, Class<T> domainType, String containerName) {
        containerName = this.getContainerNameOverride(containerName);
        Assert.notNull(ids, (String)"Id list should not be null");
        Assert.notNull(domainType, (String)"domainType should not be null.");
        Assert.hasText((String)containerName, (String)"container should not be null, empty or only whitespaces");
        ArrayList<String> idList = new ArrayList<String>();
        for (ID id : ids) {
            idList.add(CosmosUtils.getStringIDValue(id));
        }
        CosmosQuery query = new CosmosQuery(Criteria.getInstance(CriteriaType.IN, "id", Collections.singletonList(idList), Part.IgnoreCaseType.NEVER));
        return this.find(query, domainType, containerName);
    }

    @Override
    public <T> Iterable<T> find(@NonNull CosmosQuery query, @NonNull Class<T> domainType, String containerName) {
        Assert.notNull((Object)query, (String)"DocumentQuery should not be null.");
        Assert.notNull(domainType, (String)"domainType should not be null.");
        Assert.hasText((String)containerName, (String)"container should not be null, empty or only whitespaces");
        return this.findItems(query, containerName, domainType);
    }

    @Override
    public <T> Boolean exists(@NonNull CosmosQuery query, @NonNull Class<T> domainType, String containerName) {
        return this.count(query, containerName) > 0L;
    }

    @Override
    public <T> Iterable<T> delete(@NonNull CosmosQuery query, @NonNull Class<T> domainType, @NonNull String containerName) {
        Assert.notNull((Object)query, (String)"DocumentQuery should not be null.");
        Assert.notNull(domainType, (String)"domainType should not be null.");
        Assert.hasText((String)containerName, (String)"container should not be null, empty or only whitespaces");
        String finalContainerName = this.getContainerNameOverride(containerName);
        List results = (List)this.findItemsAsFlux(query, finalContainerName, domainType).collectList().block();
        assert (results != null);
        return results.stream().map(item -> this.deleteItem((JsonNode)item, finalContainerName, domainType)).collect(Collectors.toList());
    }

    @Override
    public <T> Page<T> findAll(Pageable pageable, Class<T> domainType, String containerName) {
        CosmosQuery query = new CosmosQuery(Criteria.getInstance(CriteriaType.ALL)).with(pageable);
        if (pageable.getSort().isSorted()) {
            query.with(pageable.getSort());
        }
        return this.paginationQuery(query, domainType, containerName);
    }

    @Override
    public <T> Page<T> runPaginationQuery(SqlQuerySpec querySpec, Pageable pageable, Class<?> domainType, Class<T> returnType) {
        String containerName = this.getContainerName(domainType);
        SqlQuerySpec sortedQuerySpec = NativeQueryGenerator.getInstance().generateSortedQuery(querySpec, pageable.getSort());
        SqlQuerySpec countQuerySpec = NativeQueryGenerator.getInstance().generateCountQuery(querySpec);
        return this.paginationQuery(sortedQuerySpec, countQuerySpec, pageable, pageable.getSort(), returnType, containerName, Optional.empty());
    }

    @Override
    public <T> Page<T> paginationQuery(CosmosQuery query, Class<T> domainType, String containerName) {
        containerName = this.getContainerNameOverride(containerName);
        SqlQuerySpec querySpec = new FindQuerySpecGenerator().generateCosmos(query);
        SqlQuerySpec countQuerySpec = new CountQueryGenerator().generateCosmos(query);
        Optional<Object> partitionKeyValue = query.getPartitionKeyValue(domainType);
        return this.paginationQuery(querySpec, countQuerySpec, query.getPageable(), query.getSort(), domainType, containerName, partitionKeyValue);
    }

    @Override
    public <T> Slice<T> sliceQuery(CosmosQuery query, Class<T> domainType, String containerName) {
        containerName = this.getContainerNameOverride(containerName);
        SqlQuerySpec querySpec = new FindQuerySpecGenerator().generateCosmos(query);
        Optional<Object> partitionKeyValue = query.getPartitionKeyValue(domainType);
        return this.sliceQuery(querySpec, query.getPageable(), query.getSort(), domainType, containerName, partitionKeyValue);
    }

    @Override
    public <T> Slice<T> runSliceQuery(SqlQuerySpec querySpec, Pageable pageable, Class<?> domainType, Class<T> returnType) {
        String containerName = this.getContainerName(domainType);
        SqlQuerySpec sortedQuerySpec = NativeQueryGenerator.getInstance().generateSortedQuery(querySpec, pageable.getSort());
        return this.sliceQuery(sortedQuerySpec, pageable, pageable.getSort(), returnType, containerName, Optional.empty());
    }

    private <T> Page<T> paginationQuery(SqlQuerySpec querySpec, SqlQuerySpec countQuerySpec, Pageable pageable, Sort sort, Class<T> returnType, String containerName, Optional<Object> partitionKeyValue) {
        containerName = this.getContainerNameOverride(containerName);
        Slice<T> response = this.sliceQuery(querySpec, pageable, sort, returnType, containerName, partitionKeyValue);
        long total = this.getCountValue(countQuerySpec, containerName);
        return new CosmosPageImpl(response.getContent(), response.getPageable(), total);
    }

    private <T> Slice<T> sliceQuery(SqlQuerySpec querySpec, Pageable pageable, Sort sort, Class<T> returnType, String containerName, Optional<Object> partitionKeyValue) {
        Assert.isTrue((pageable.getPageSize() > 0 ? 1 : 0) != 0, (String)"pageable should have page size larger than 0");
        Assert.hasText((String)containerName, (String)"container should not be null, empty or only whitespaces");
        containerName = this.getContainerNameOverride(containerName);
        CosmosQueryRequestOptions cosmosQueryRequestOptions = new CosmosQueryRequestOptions();
        cosmosQueryRequestOptions.setQueryMetricsEnabled(this.queryMetricsEnabled);
        cosmosQueryRequestOptions.setMaxDegreeOfParallelism(this.maxDegreeOfParallelism);
        cosmosQueryRequestOptions.setMaxBufferedItemCount(this.maxBufferedItemCount);
        cosmosQueryRequestOptions.setResponseContinuationTokenLimitInKb(this.responseContinuationTokenLimitInKb);
        partitionKeyValue.ifPresent(o -> {
            LOGGER.debug("Setting partition key {}", o);
            cosmosQueryRequestOptions.setPartitionKey(new PartitionKey(o));
        });
        CosmosAsyncContainer container = this.getCosmosAsyncClient().getDatabase(this.getDatabaseName()).getContainer(containerName);
        int feedResponseContentSize = pageable.getPageSize();
        String continuationToken = null;
        int offsetForPageWithoutContToken = 0;
        if (pageable instanceof CosmosPageRequest) {
            if (((CosmosPageRequest)pageable).getRequestContinuation() == null) {
                feedResponseContentSize = (int)((long)(feedResponseContentSize + feedResponseContentSize * pageable.getPageNumber()) + pageable.getOffset());
                offsetForPageWithoutContToken = pageable.getPageNumber() * pageable.getPageSize() + (int)pageable.getOffset();
            }
            continuationToken = ((CosmosPageRequest)pageable).getRequestContinuation();
        } else {
            feedResponseContentSize += feedResponseContentSize * pageable.getPageNumber();
            offsetForPageWithoutContToken = pageable.getPageNumber() * pageable.getPageSize();
        }
        ArrayList<T> result = new ArrayList<T>();
        do {
            Flux feedResponseFlux = container.queryItems(querySpec, cosmosQueryRequestOptions, JsonNode.class).byPage(continuationToken, feedResponseContentSize);
            FeedResponse feedResponse = (FeedResponse)feedResponseFlux.publishOn(Schedulers.parallel()).doOnNext(propertiesFeedResponse -> CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, propertiesFeedResponse.getCosmosDiagnostics(), propertiesFeedResponse)).onErrorResume(throwable -> CosmosExceptionUtils.exceptionHandler("Failed to query items", throwable, this.responseDiagnosticsProcessor)).next().block();
            assert (feedResponse != null);
            Iterator it = feedResponse.getResults().iterator();
            for (int index = 0; it.hasNext() && index < pageable.getPageSize() + offsetForPageWithoutContToken; ++index) {
                JsonNode jsonNode = (JsonNode)it.next();
                if (jsonNode == null || index < offsetForPageWithoutContToken) continue;
                this.maybeEmitEvent(new AfterLoadEvent<T>(jsonNode, returnType, containerName));
                T entity = this.mappingCosmosConverter.read(returnType, jsonNode);
                result.add(entity);
            }
            if (result.size() < pageable.getPageSize()) {
                feedResponseContentSize = pageable.getPageSize() - result.size();
            }
            continuationToken = feedResponse.getContinuationToken();
            offsetForPageWithoutContToken = 0;
        } while (result.size() < pageable.getPageSize() && continuationToken != null);
        CosmosPageRequest pageRequest = CosmosPageRequest.of(pageable.getOffset(), pageable.getPageNumber(), pageable.getPageSize(), continuationToken, sort);
        return new CosmosSliceImpl(result, (Pageable)pageRequest, continuationToken != null);
    }

    @Override
    public long count(String containerName) {
        Assert.hasText((String)containerName, (String)"container name should not be empty");
        containerName = this.getContainerNameOverride(containerName);
        CosmosQuery query = new CosmosQuery(Criteria.getInstance(CriteriaType.ALL));
        Long count = this.getCountValue(query, containerName);
        assert (count != null);
        return count;
    }

    @Override
    public <T> long count(CosmosQuery query, String containerName) {
        containerName = this.getContainerNameOverride(containerName);
        Assert.hasText((String)containerName, (String)"container name should not be empty");
        Long count = this.getCountValue(query, containerName);
        assert (count != null);
        return count;
    }

    @Override
    public <T> long count(SqlQuerySpec querySpec, String containerName) {
        containerName = this.getContainerNameOverride(containerName);
        Assert.hasText((String)containerName, (String)"container name should not be empty");
        Long count = this.getCountValue(querySpec, containerName);
        assert (count != null);
        return count;
    }

    @Override
    public MappingCosmosConverter getConverter() {
        return this.mappingCosmosConverter;
    }

    @Override
    public <T> Iterable<T> runQuery(SqlQuerySpec querySpec, Class<?> domainType, Class<T> returnType) {
        return this.runQuery(querySpec, Sort.unsorted(), domainType, returnType);
    }

    @Override
    public <T> Iterable<T> runQuery(SqlQuerySpec querySpec, Sort sort, Class<?> domainType, Class<T> returnType) {
        querySpec = NativeQueryGenerator.getInstance().generateSortedQuery(querySpec, sort);
        return (Iterable)this.getJsonNodeFluxFromQuerySpec(this.getContainerName(domainType), querySpec).map(jsonNode -> this.emitOnLoadEventAndConvertToDomainObject(returnType, this.getContainerName(domainType), (JsonNode)jsonNode)).collectList().block();
    }

    private void markAuditedIfConfigured(Object object) {
        if (this.cosmosAuditingHandler != null) {
            this.cosmosAuditingHandler.markAudited(object);
        }
    }

    private Long getCountValue(CosmosQuery query, String containerName) {
        SqlQuerySpec querySpec = new CountQueryGenerator().generateCosmos(query);
        return this.getCountValue(querySpec, containerName);
    }

    private Long getCountValue(SqlQuerySpec querySpec, String containerName) {
        CosmosQueryRequestOptions options = new CosmosQueryRequestOptions();
        options.setQueryMetricsEnabled(this.queryMetricsEnabled);
        options.setMaxDegreeOfParallelism(this.maxDegreeOfParallelism);
        options.setMaxBufferedItemCount(this.maxBufferedItemCount);
        options.setResponseContinuationTokenLimitInKb(this.responseContinuationTokenLimitInKb);
        containerName = this.getContainerNameOverride(containerName);
        return (Long)this.executeQuery(querySpec, containerName, options).publishOn(Schedulers.parallel()).onErrorResume(throwable -> CosmosExceptionUtils.exceptionHandler("Failed to get count value", throwable, this.responseDiagnosticsProcessor)).doOnNext(response -> CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, response.getCosmosDiagnostics(), response)).next().map(r -> ((JsonNode)r.getResults().get(0)).asLong()).block();
    }

    private Flux<FeedResponse<JsonNode>> executeQuery(SqlQuerySpec sqlQuerySpec, String containerName, CosmosQueryRequestOptions options) {
        containerName = this.getContainerNameOverride(containerName);
        return this.getCosmosAsyncClient().getDatabase(this.getDatabaseName()).getContainer(containerName).queryItems(sqlQuerySpec, options, JsonNode.class).byPage();
    }

    private <T> Flux<JsonNode> findItemsAsFlux(@NonNull CosmosQuery query, @NonNull String containerName, @NonNull Class<T> domainType) {
        SqlQuerySpec sqlQuerySpec = new FindQuerySpecGenerator().generateCosmos(query);
        CosmosQueryRequestOptions cosmosQueryRequestOptions = new CosmosQueryRequestOptions();
        containerName = this.getContainerNameOverride(containerName);
        cosmosQueryRequestOptions.setQueryMetricsEnabled(this.queryMetricsEnabled);
        cosmosQueryRequestOptions.setMaxDegreeOfParallelism(this.maxDegreeOfParallelism);
        cosmosQueryRequestOptions.setMaxBufferedItemCount(this.maxBufferedItemCount);
        cosmosQueryRequestOptions.setResponseContinuationTokenLimitInKb(this.responseContinuationTokenLimitInKb);
        Optional<Object> partitionKeyValue = query.getPartitionKeyValue(domainType);
        partitionKeyValue.ifPresent(o -> {
            LOGGER.debug("Setting partition key {}", o);
            cosmosQueryRequestOptions.setPartitionKey(new PartitionKey(o));
        });
        return this.getCosmosAsyncClient().getDatabase(this.getDatabaseName()).getContainer(containerName).queryItems(sqlQuerySpec, cosmosQueryRequestOptions, JsonNode.class).byPage().publishOn(Schedulers.parallel()).flatMap(cosmosItemFeedResponse -> {
            CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosItemFeedResponse.getCosmosDiagnostics(), cosmosItemFeedResponse);
            return Flux.fromIterable((Iterable)cosmosItemFeedResponse.getResults());
        }).onErrorResume(throwable -> CosmosExceptionUtils.exceptionHandler("Failed to find items", throwable, this.responseDiagnosticsProcessor));
    }

    private Flux<JsonNode> getJsonNodeFluxFromQuerySpec(@NonNull String containerName, SqlQuerySpec sqlQuerySpec) {
        CosmosQueryRequestOptions cosmosQueryRequestOptions = new CosmosQueryRequestOptions();
        cosmosQueryRequestOptions.setQueryMetricsEnabled(this.queryMetricsEnabled);
        cosmosQueryRequestOptions.setMaxDegreeOfParallelism(this.maxDegreeOfParallelism);
        cosmosQueryRequestOptions.setMaxBufferedItemCount(this.maxBufferedItemCount);
        cosmosQueryRequestOptions.setResponseContinuationTokenLimitInKb(this.responseContinuationTokenLimitInKb);
        containerName = this.getContainerNameOverride(containerName);
        return this.getCosmosAsyncClient().getDatabase(this.getDatabaseName()).getContainer(containerName).queryItems(sqlQuerySpec, cosmosQueryRequestOptions, JsonNode.class).byPage().publishOn(Schedulers.parallel()).flatMap(cosmosItemFeedResponse -> {
            CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosItemFeedResponse.getCosmosDiagnostics(), cosmosItemFeedResponse);
            return Flux.fromIterable((Iterable)cosmosItemFeedResponse.getResults());
        }).onErrorResume(throwable -> CosmosExceptionUtils.exceptionHandler("Failed to find items", throwable, this.responseDiagnosticsProcessor));
    }

    private <T> Iterable<T> findItems(@NonNull CosmosQuery query, @NonNull String containerName, @NonNull Class<T> domainType) {
        String finalContainerName = this.getContainerNameOverride(containerName);
        return this.findItemsAsFlux(query, finalContainerName, domainType).map(jsonNode -> this.emitOnLoadEventAndConvertToDomainObject(domainType, finalContainerName, (JsonNode)jsonNode)).toIterable();
    }

    private <T> T deleteItem(@NonNull JsonNode jsonNode, String containerName, @NonNull Class<T> domainType) {
        CosmosItemRequestOptions options = new CosmosItemRequestOptions();
        this.applyVersioning(domainType, jsonNode, options);
        containerName = this.getContainerNameOverride(containerName);
        return (T)this.getCosmosAsyncClient().getDatabase(this.getDatabaseName()).getContainer(containerName).deleteItem((Object)jsonNode, options).publishOn(Schedulers.parallel()).doOnNext(response -> CosmosUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, response.getDiagnostics(), null)).onErrorResume(throwable -> CosmosExceptionUtils.exceptionHandler("Failed to delete item", throwable, this.responseDiagnosticsProcessor)).flatMap(objectCosmosItemResponse -> Mono.just(this.toDomainObject(domainType, jsonNode))).block();
    }

    private <T> T emitOnLoadEventAndConvertToDomainObject(@NonNull Class<T> domainType, String containerName, JsonNode responseJsonNode) {
        containerName = this.getContainerNameOverride(containerName);
        this.maybeEmitEvent(new AfterLoadEvent<T>(responseJsonNode, domainType, containerName));
        return this.toDomainObject(domainType, responseJsonNode);
    }

    private <T> T toDomainObject(@NonNull Class<T> domainType, JsonNode responseJsonNode) {
        return this.mappingCosmosConverter.read(domainType, responseJsonNode);
    }

    private void applyVersioning(Class<?> domainType, JsonNode jsonNode, CosmosItemRequestOptions options) {
        CosmosEntityInformation<?, ?> entityInformation = CosmosEntityInformation.getInstance(domainType);
        if (entityInformation.isVersioned()) {
            options.setIfMatchETag(jsonNode.get("_etag").asText());
        }
    }

    private void maybeEmitEvent(CosmosMappingEvent<?> event) {
        if (this.canPublishEvent()) {
            this.applicationContext.publishEvent(event);
        }
    }

    private boolean canPublishEvent() {
        return this.applicationContext != null;
    }
}

