/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.exception;

import com.azure.cosmos.CosmosException;
import com.azure.spring.data.cosmos.common.CosmosUtils;
import com.azure.spring.data.cosmos.core.ResponseDiagnosticsProcessor;
import com.azure.spring.data.cosmos.exception.CosmosAccessException;
import org.springframework.util.ObjectUtils;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public class CosmosExceptionUtils {
    public static <T> Mono<T> exceptionHandler(String message, Throwable throwable, ResponseDiagnosticsProcessor responseDiagnosticsProcessor) {
        Throwable unwrappedThrowable;
        if (ObjectUtils.isEmpty((Object)message)) {
            message = "Failed to access cosmos db database";
        }
        if ((unwrappedThrowable = Exceptions.unwrap((Throwable)throwable)) instanceof CosmosException) {
            CosmosException cosmosException = (CosmosException)unwrappedThrowable;
            CosmosUtils.fillAndProcessCosmosExceptionDiagnostics(responseDiagnosticsProcessor, cosmosException);
        }
        throw new CosmosAccessException(message, unwrappedThrowable);
    }

    public static <T> Mono<T> findAPIExceptionHandler(String message, Throwable throwable, ResponseDiagnosticsProcessor responseDiagnosticsProcessor) {
        Throwable unwrappedThrowable;
        if (ObjectUtils.isEmpty((Object)message)) {
            message = "Failed to find item";
        }
        if ((unwrappedThrowable = Exceptions.unwrap((Throwable)throwable)) instanceof CosmosException) {
            CosmosException cosmosClientException = (CosmosException)unwrappedThrowable;
            CosmosUtils.fillAndProcessCosmosExceptionDiagnostics(responseDiagnosticsProcessor, cosmosClientException);
            if (cosmosClientException.getStatusCode() == 404) {
                return Mono.empty();
            }
        }
        throw new CosmosAccessException(message, unwrappedThrowable);
    }
}

