/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.core.generator;

import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.spring.data.cosmos.core.convert.MappingCosmosConverter;
import com.azure.spring.data.cosmos.core.query.CosmosQuery;
import com.azure.spring.data.cosmos.core.query.Criteria;
import com.azure.spring.data.cosmos.core.query.CriteriaType;
import com.azure.spring.data.cosmos.exception.IllegalQueryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.util.Pair;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractQueryGenerator {
    protected AbstractQueryGenerator() {
    }

    private String generateQueryParameter(@NonNull String subject) {
        return subject.replaceAll("\\.", "_") + UUID.randomUUID().toString().replaceAll("-", "_");
    }

    private String generateUnaryQuery(@NonNull Criteria criteria) {
        Assert.isTrue((boolean)criteria.getSubjectValues().isEmpty(), (String)"Unary criteria should have no one subject value");
        Assert.isTrue((boolean)CriteriaType.isUnary(criteria.getType()), (String)"Criteria type should be unary operation");
        String subject = criteria.getSubject();
        if (CriteriaType.isFunction(criteria.getType())) {
            return String.format("%s(r.%s)", criteria.getType().getSqlKeyword(), subject);
        }
        return String.format("r.%s %s", subject, criteria.getType().getSqlKeyword());
    }

    private String generateBinaryQuery(@NonNull Criteria criteria, @NonNull List<Pair<String, Object>> parameters) {
        Assert.isTrue((criteria.getSubjectValues().size() == 1 ? 1 : 0) != 0, (String)"Binary criteria should have only one subject value");
        Assert.isTrue((boolean)CriteriaType.isBinary(criteria.getType()), (String)"Criteria type should be binary operation");
        String subject = criteria.getSubject();
        Object subjectValue = MappingCosmosConverter.toCosmosDbValue(criteria.getSubjectValues().get(0));
        String parameter = this.generateQueryParameter(subject);
        Part.IgnoreCaseType ignoreCase = criteria.getIgnoreCase();
        String sqlKeyword = criteria.getType().getSqlKeyword();
        parameters.add((Pair<String, Object>)Pair.of((Object)parameter, (Object)subjectValue));
        if (CriteriaType.isFunction(criteria.getType())) {
            return this.getFunctionCondition(ignoreCase, sqlKeyword, subject, parameter);
        }
        return this.getCondition(ignoreCase, sqlKeyword, subject, parameter);
    }

    private String getCondition(Part.IgnoreCaseType ignoreCase, String sqlKeyword, String subject, String parameter) {
        if (Part.IgnoreCaseType.NEVER == ignoreCase) {
            return String.format("r.%s %s @%s", subject, sqlKeyword, parameter);
        }
        return String.format("UPPER(r.%s) %s UPPER(@%s)", subject, sqlKeyword, parameter);
    }

    private String getFunctionCondition(Part.IgnoreCaseType ignoreCase, String sqlKeyword, String subject, String parameter) {
        if (Part.IgnoreCaseType.NEVER == ignoreCase) {
            return String.format("%s(r.%s, @%s)", sqlKeyword, subject, parameter);
        }
        return String.format("%s(UPPER(r.%s), UPPER(@%s))", sqlKeyword, subject, parameter);
    }

    private String generateBetween(@NonNull Criteria criteria, @NonNull List<Pair<String, Object>> parameters) {
        String subject = criteria.getSubject();
        Object value1 = MappingCosmosConverter.toCosmosDbValue(criteria.getSubjectValues().get(0));
        Object value2 = MappingCosmosConverter.toCosmosDbValue(criteria.getSubjectValues().get(1));
        String subject1 = subject + "start";
        String subject2 = subject + "end";
        String parameter1 = this.generateQueryParameter(subject1);
        String parameter2 = this.generateQueryParameter(subject2);
        String keyword = criteria.getType().getSqlKeyword();
        parameters.add((Pair<String, Object>)Pair.of((Object)parameter1, (Object)value1));
        parameters.add((Pair<String, Object>)Pair.of((Object)parameter2, (Object)value2));
        return String.format("(r.%s %s @%s AND @%s)", subject, keyword, parameter1, parameter2);
    }

    private String generateClosedQuery(@NonNull String left, @NonNull String right, CriteriaType type) {
        Assert.isTrue((CriteriaType.isClosed(type) && CriteriaType.isBinary(type) ? 1 : 0) != 0, (String)"Criteria type should be binary and closure operation");
        return String.join((CharSequence)" ", left, type.getSqlKeyword(), right);
    }

    private String generateInQuery(@NonNull Criteria criteria, @NonNull List<Pair<String, Object>> parameters) {
        Assert.isTrue((criteria.getSubjectValues().size() == 1 ? 1 : 0) != 0, (String)"Criteria should have only one subject value");
        if (!(criteria.getSubjectValues().get(0) instanceof Collection)) {
            throw new IllegalQueryException("IN keyword requires Collection type in parameters");
        }
        Collection values = (Collection)criteria.getSubjectValues().get(0);
        ArrayList<String> paras = new ArrayList<String>();
        for (Object o : values) {
            if (o instanceof String || o instanceof Integer || o instanceof Long || o instanceof Boolean) {
                String key = "p" + parameters.size();
                paras.add("@" + key);
                parameters.add((Pair<String, Object>)Pair.of((Object)key, o));
                continue;
            }
            throw new IllegalQueryException("IN keyword Range only support Number and String type.");
        }
        return String.format("r.%s %s (%s)", criteria.getSubject(), criteria.getType().getSqlKeyword(), String.join((CharSequence)",", paras));
    }

    private String generateQueryBody(@NonNull Criteria criteria, @NonNull List<Pair<String, Object>> parameters) {
        CriteriaType type = criteria.getType();
        switch (type) {
            case ALL: {
                return "";
            }
            case IN: 
            case NOT_IN: {
                return this.generateInQuery(criteria, parameters);
            }
            case BETWEEN: {
                return this.generateBetween(criteria, parameters);
            }
            case IS_NULL: 
            case IS_NOT_NULL: 
            case FALSE: 
            case TRUE: {
                return this.generateUnaryQuery(criteria);
            }
            case IS_EQUAL: 
            case NOT: 
            case BEFORE: 
            case AFTER: 
            case LESS_THAN: 
            case LESS_THAN_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case CONTAINING: 
            case ENDS_WITH: 
            case STARTS_WITH: 
            case ARRAY_CONTAINS: {
                return this.generateBinaryQuery(criteria, parameters);
            }
            case AND: 
            case OR: {
                Assert.isTrue((criteria.getSubCriteria().size() == 2 ? 1 : 0) != 0, (String)"criteria should have two SubCriteria");
                String left = this.generateQueryBody(criteria.getSubCriteria().get(0), parameters);
                String right = this.generateQueryBody(criteria.getSubCriteria().get(1), parameters);
                return this.generateClosedQuery(left, right, type);
            }
        }
        throw new UnsupportedOperationException("unsupported Criteria type: " + (Object)((Object)type));
    }

    @NonNull
    private Pair<String, List<Pair<String, Object>>> generateQueryBody(@NonNull CosmosQuery query) {
        ArrayList<Pair<String, Object>> parameters = new ArrayList<Pair<String, Object>>();
        String queryString = this.generateQueryBody(query.getCriteria(), parameters);
        if (StringUtils.hasText((String)queryString)) {
            queryString = String.join((CharSequence)" ", "WHERE", queryString);
        }
        return Pair.of((Object)queryString, parameters);
    }

    private String getParameter(@NonNull Sort.Order order) {
        Assert.isTrue((!order.isIgnoreCase() ? 1 : 0) != 0, (String)"Ignore case is not supported");
        String direction = order.isDescending() ? "DESC" : "ASC";
        return String.format("r.%s %s", order.getProperty(), direction);
    }

    private String generateQuerySort(@NonNull Sort sort) {
        if (sort.isUnsorted()) {
            return "";
        }
        String queryTail = "ORDER BY";
        List subjects = sort.stream().map(this::getParameter).collect(Collectors.toList());
        return "ORDER BY " + String.join((CharSequence)",", subjects);
    }

    @NonNull
    private String generateQueryTail(@NonNull CosmosQuery query) {
        ArrayList<String> queryTails = new ArrayList<String>();
        queryTails.add(this.generateQuerySort(query.getSort()));
        return String.join((CharSequence)" ", queryTails.stream().filter(StringUtils::hasText).collect(Collectors.toList()));
    }

    protected SqlQuerySpec generateCosmosQuery(@NonNull CosmosQuery query, @NonNull String queryHead) {
        Pair<String, List<Pair<String, Object>>> queryBody = this.generateQueryBody(query);
        String queryString = String.join((CharSequence)" ", queryHead, (CharSequence)queryBody.getFirst(), this.generateQueryTail(query));
        List parameters = (List)queryBody.getSecond();
        List sqlParameters = parameters.stream().map(p -> new SqlParameter("@" + (String)p.getFirst(), MappingCosmosConverter.toCosmosDbValue(p.getSecond()))).collect(Collectors.toList());
        if (query.getLimit() > 0) {
            queryString = queryString + " OFFSET 0 LIMIT " + query.getLimit();
        }
        return new SqlQuerySpec(queryString, sqlParameters);
    }
}

