/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.config;

import com.azure.spring.data.cosmos.config.DatabaseThroughputConfig;
import com.azure.spring.data.cosmos.core.ResponseDiagnosticsProcessor;
import java.beans.ConstructorProperties;

public class CosmosConfig {
    private final ResponseDiagnosticsProcessor responseDiagnosticsProcessor;
    private final DatabaseThroughputConfig databaseThroughputConfig;
    private final boolean queryMetricsEnabled;
    private final int maxDegreeOfParallelism;
    private final int maxBufferedItemCount;
    private final int responseContinuationTokenLimitInKb;

    @ConstructorProperties(value={"responseDiagnosticsProcessor", "queryMetricsEnabled"})
    public CosmosConfig(ResponseDiagnosticsProcessor responseDiagnosticsProcessor, boolean queryMetricsEnabled) {
        this(responseDiagnosticsProcessor, null, queryMetricsEnabled);
    }

    @ConstructorProperties(value={"responseDiagnosticsProcessor", "databaseThroughputConfig", "queryMetricsEnabled"})
    public CosmosConfig(ResponseDiagnosticsProcessor responseDiagnosticsProcessor, DatabaseThroughputConfig databaseThroughputConfig, boolean queryMetricsEnabled) {
        this.responseDiagnosticsProcessor = responseDiagnosticsProcessor;
        this.databaseThroughputConfig = databaseThroughputConfig;
        this.queryMetricsEnabled = queryMetricsEnabled;
        this.maxDegreeOfParallelism = 0;
        this.maxBufferedItemCount = 0;
        this.responseContinuationTokenLimitInKb = 0;
    }

    @ConstructorProperties(value={"responseDiagnosticsProcessor", "databaseThroughputConfig", "queryMetricsEnabled", "maxDegreeOfParallelism"})
    CosmosConfig(ResponseDiagnosticsProcessor responseDiagnosticsProcessor, DatabaseThroughputConfig databaseThroughputConfig, boolean queryMetricsEnabled, int maxDegreeOfParallelism) {
        this.responseDiagnosticsProcessor = responseDiagnosticsProcessor;
        this.databaseThroughputConfig = databaseThroughputConfig;
        this.queryMetricsEnabled = queryMetricsEnabled;
        this.maxDegreeOfParallelism = maxDegreeOfParallelism;
        this.maxBufferedItemCount = 0;
        this.responseContinuationTokenLimitInKb = 0;
    }

    @ConstructorProperties(value={"responseDiagnosticsProcessor", "databaseThroughputConfig", "queryMetricsEnabled", "maxDegreeOfParallelism", "maxBufferedItemCount"})
    CosmosConfig(ResponseDiagnosticsProcessor responseDiagnosticsProcessor, DatabaseThroughputConfig databaseThroughputConfig, boolean queryMetricsEnabled, int maxDegreeOfParallelism, int maxBufferedItemCount) {
        this.responseDiagnosticsProcessor = responseDiagnosticsProcessor;
        this.databaseThroughputConfig = databaseThroughputConfig;
        this.queryMetricsEnabled = queryMetricsEnabled;
        this.maxDegreeOfParallelism = maxDegreeOfParallelism;
        this.maxBufferedItemCount = maxBufferedItemCount;
        this.responseContinuationTokenLimitInKb = 0;
    }

    @ConstructorProperties(value={"responseDiagnosticsProcessor", "databaseThroughputConfig", "queryMetricsEnabled", "maxDegreeOfParallelism", "maxBufferedItemCount", "responseContinuationTokenLimitInKb"})
    CosmosConfig(ResponseDiagnosticsProcessor responseDiagnosticsProcessor, DatabaseThroughputConfig databaseThroughputConfig, boolean queryMetricsEnabled, int maxDegreeOfParallelism, int maxBufferedItemCount, int responseContinuationTokenLimitInKb) {
        this.responseDiagnosticsProcessor = responseDiagnosticsProcessor;
        this.databaseThroughputConfig = databaseThroughputConfig;
        this.queryMetricsEnabled = queryMetricsEnabled;
        this.maxDegreeOfParallelism = maxDegreeOfParallelism;
        this.maxBufferedItemCount = maxBufferedItemCount;
        this.responseContinuationTokenLimitInKb = responseContinuationTokenLimitInKb;
    }

    public ResponseDiagnosticsProcessor getResponseDiagnosticsProcessor() {
        return this.responseDiagnosticsProcessor;
    }

    public boolean isQueryMetricsEnabled() {
        return this.queryMetricsEnabled;
    }

    public int getMaxDegreeOfParallelism() {
        return this.maxDegreeOfParallelism;
    }

    public int getMaxBufferedItemCount() {
        return this.maxBufferedItemCount;
    }

    public int getResponseContinuationTokenLimitInKb() {
        return this.responseContinuationTokenLimitInKb;
    }

    public DatabaseThroughputConfig getDatabaseThroughputConfig() {
        return this.databaseThroughputConfig;
    }

    public static CosmosConfigBuilder builder() {
        return new CosmosConfigBuilder();
    }

    public static class CosmosConfigBuilder {
        private ResponseDiagnosticsProcessor responseDiagnosticsProcessor;
        private DatabaseThroughputConfig databaseThroughputConfig;
        private boolean queryMetricsEnabled;
        private int maxDegreeOfParallelism;
        private int maxBufferedItemCount;
        private int responseContinuationTokenLimitInKb;

        CosmosConfigBuilder() {
        }

        public CosmosConfigBuilder responseDiagnosticsProcessor(ResponseDiagnosticsProcessor responseDiagnosticsProcessor) {
            this.responseDiagnosticsProcessor = responseDiagnosticsProcessor;
            return this;
        }

        public CosmosConfigBuilder enableQueryMetrics(boolean queryMetricsEnabled) {
            this.queryMetricsEnabled = queryMetricsEnabled;
            return this;
        }

        public CosmosConfigBuilder maxDegreeOfParallelism(int maxDegreeOfParallelism) {
            this.maxDegreeOfParallelism = maxDegreeOfParallelism;
            return this;
        }

        public CosmosConfigBuilder maxBufferedItemCount(int maxBufferedItemCount) {
            this.maxBufferedItemCount = maxBufferedItemCount;
            return this;
        }

        public CosmosConfigBuilder responseContinuationTokenLimitInKb(int responseContinuationTokenLimitInKb) {
            this.responseContinuationTokenLimitInKb = responseContinuationTokenLimitInKb;
            return this;
        }

        public CosmosConfigBuilder enableDatabaseThroughput(boolean autoscale, int requestUnits) {
            this.databaseThroughputConfig = new DatabaseThroughputConfig(autoscale, requestUnits);
            return this;
        }

        public CosmosConfig build() {
            return new CosmosConfig(this.responseDiagnosticsProcessor, this.databaseThroughputConfig, this.queryMetricsEnabled, this.maxDegreeOfParallelism, this.maxBufferedItemCount, this.responseContinuationTokenLimitInKb);
        }

        public String toString() {
            return "CosmosConfigBuilder{responseDiagnosticsProcessor=" + this.responseDiagnosticsProcessor + ", databaseThroughputConfig=" + this.databaseThroughputConfig + ", queryMetricsEnabled=" + this.queryMetricsEnabled + ", maxDegreeOfParallelism=" + this.maxDegreeOfParallelism + ", maxBufferedItemCount=" + this.maxBufferedItemCount + ", responseContinuationTokenLimitInKb=" + this.responseContinuationTokenLimitInKb + '}';
        }
    }
}

