/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.core.convert;

import com.azure.spring.data.cosmos.core.convert.ObjectMapperFactory;
import com.azure.spring.data.cosmos.core.mapping.CosmosPersistentEntity;
import com.azure.spring.data.cosmos.core.mapping.CosmosPersistentProperty;
import com.azure.spring.data.cosmos.exception.CosmosAccessException;
import com.azure.spring.data.cosmos.repository.support.CosmosEntityInformation;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.EntityConverter;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.util.Assert;

public class MappingCosmosConverter
implements EntityConverter<CosmosPersistentEntity<?>, CosmosPersistentProperty, Object, JsonNode>,
ApplicationContextAware {
    protected final MappingContext<? extends CosmosPersistentEntity<?>, CosmosPersistentProperty> mappingContext;
    protected GenericConversionService conversionService;
    private ApplicationContext applicationContext;
    private final ObjectMapper objectMapper;

    public MappingCosmosConverter(MappingContext<? extends CosmosPersistentEntity<?>, CosmosPersistentProperty> mappingContext, @Qualifier(value="cosmosObjectMapper") ObjectMapper objectMapper) {
        this.mappingContext = mappingContext;
        this.conversionService = new GenericConversionService();
        this.objectMapper = objectMapper == null ? ObjectMapperFactory.getObjectMapper() : objectMapper;
    }

    public <R> R read(Class<R> type, JsonNode jsonNode) {
        CosmosPersistentEntity entity = (CosmosPersistentEntity)this.mappingContext.getPersistentEntity(type);
        return this.readInternal(entity, type, jsonNode);
    }

    public void write(Object source, JsonNode sink) {
        throw new UnsupportedOperationException("The feature is not implemented yet");
    }

    private <R> R readInternal(CosmosPersistentEntity<?> entity, Class<R> type, JsonNode jsonNode) {
        try {
            JsonNode etag;
            if (jsonNode.isValueNode()) {
                return (R)this.objectMapper.treeToValue((TreeNode)jsonNode, type);
            }
            Assert.notNull(entity, (String)"Entity is null.");
            ObjectNode objectNode = (ObjectNode)jsonNode.deepCopy();
            CosmosPersistentProperty idProperty = (CosmosPersistentProperty)entity.getIdProperty();
            JsonNode idValue = jsonNode.get("id");
            if (idProperty != null) {
                objectNode.remove("id");
                objectNode.set(idProperty.getName(), idValue);
            }
            if ((etag = jsonNode.get("_etag")) != null) {
                this.mapEtagToVersionField(type, objectNode, etag);
            }
            return (R)this.objectMapper.treeToValue((TreeNode)objectNode, type);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Failed to read the source document " + jsonNode.toPrettyString() + "  to target type " + type, e);
        }
    }

    public JsonNode writeJsonNode(Object sourceEntity) {
        ObjectNode cosmosObjectNode;
        if (sourceEntity == null) {
            return null;
        }
        CosmosPersistentEntity persistentEntity = (CosmosPersistentEntity)this.mappingContext.getPersistentEntity(sourceEntity.getClass());
        if (persistentEntity == null) {
            throw new MappingException("no mapping metadata for entity type: " + sourceEntity.getClass().getName());
        }
        ConvertingPropertyAccessor<?> accessor = this.getPropertyAccessor(sourceEntity);
        CosmosPersistentProperty idProperty = (CosmosPersistentProperty)persistentEntity.getIdProperty();
        try {
            String valueAsString = this.objectMapper.writeValueAsString(sourceEntity);
            cosmosObjectNode = (ObjectNode)this.objectMapper.readTree(valueAsString);
        }
        catch (JsonProcessingException e) {
            throw new CosmosAccessException("Failed to map document value.", (Exception)((Object)e));
        }
        if (idProperty != null) {
            Object value = accessor.getProperty((PersistentProperty)idProperty);
            String id = value == null ? null : value.toString();
            cosmosObjectNode.put("id", id);
        }
        this.mapVersionFieldToEtag(sourceEntity, cosmosObjectNode);
        return cosmosObjectNode;
    }

    private void mapVersionFieldToEtag(Object sourceEntity, ObjectNode cosmosObjectNode) {
        CosmosEntityInformation<?, ?> entityInfo = CosmosEntityInformation.getInstance(sourceEntity.getClass());
        if (entityInfo.isVersioned() && !entityInfo.getVersionFieldName().equals("_etag")) {
            cosmosObjectNode.remove(entityInfo.getVersionFieldName());
            cosmosObjectNode.put("_etag", entityInfo.getVersionFieldValue(sourceEntity));
        }
    }

    private <R> void mapEtagToVersionField(Class<R> type, ObjectNode objectNode, JsonNode etagValue) {
        CosmosEntityInformation<R, R> entityInfo = CosmosEntityInformation.getInstance(type);
        if (entityInfo.isVersioned()) {
            objectNode.set(entityInfo.getVersionFieldName(), etagValue);
            if (!entityInfo.getVersionFieldName().equals("_etag")) {
                objectNode.remove("_etag");
            }
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public MappingContext<? extends CosmosPersistentEntity<?>, CosmosPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    private ConvertingPropertyAccessor<?> getPropertyAccessor(Object entity) {
        CosmosPersistentEntity entityInformation = (CosmosPersistentEntity)this.mappingContext.getPersistentEntity(entity.getClass());
        Assert.notNull((Object)entityInformation, (String)"EntityInformation should not be null.");
        PersistentPropertyAccessor accessor = entityInformation.getPropertyAccessor(entity);
        return new ConvertingPropertyAccessor(accessor, (ConversionService)this.conversionService);
    }

    public static Object toCosmosDbValue(Object fromPropertyValue) {
        if (fromPropertyValue == null) {
            return null;
        }
        if (fromPropertyValue instanceof Date) {
            fromPropertyValue = ((Date)fromPropertyValue).getTime();
        } else if (fromPropertyValue instanceof ZonedDateTime) {
            fromPropertyValue = ((ZonedDateTime)fromPropertyValue).format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss:SSSXXX"));
        } else if (fromPropertyValue instanceof Enum) {
            fromPropertyValue = fromPropertyValue.toString();
        } else if (fromPropertyValue instanceof Optional) {
            fromPropertyValue = ((Optional)fromPropertyValue).get();
        }
        return fromPropertyValue;
    }
}

