/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.repository.support;

import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.spring.data.cosmos.core.CosmosOperations;
import com.azure.spring.data.cosmos.core.convert.MappingCosmosConverter;
import com.azure.spring.data.cosmos.core.query.CosmosQuery;
import com.azure.spring.data.cosmos.repository.query.AbstractCosmosQuery;
import com.azure.spring.data.cosmos.repository.query.CosmosEntityMetadata;
import com.azure.spring.data.cosmos.repository.query.CosmosParameterAccessor;
import com.azure.spring.data.cosmos.repository.query.CosmosParameterParameterAccessor;
import com.azure.spring.data.cosmos.repository.query.CosmosQueryMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ResultProcessor;

public class StringBasedCosmosQuery
extends AbstractCosmosQuery {
    private static final Pattern COUNT_QUERY_PATTERN = Pattern.compile("^\\s*select\\s+value\\s+count.*", 2);
    private final String query;

    public StringBasedCosmosQuery(CosmosQueryMethod queryMethod, CosmosOperations dbOperations) {
        super(queryMethod, dbOperations);
        this.query = queryMethod.getQueryAnnotation();
    }

    @Override
    protected CosmosQuery createQuery(CosmosParameterAccessor accessor) {
        return null;
    }

    @Override
    public Object execute(Object[] parameters) {
        CosmosParameterParameterAccessor accessor = new CosmosParameterParameterAccessor(this.getQueryMethod(), parameters);
        ResultProcessor processor = this.getQueryMethod().getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        String expandedQuery = this.query;
        ArrayList<SqlParameter> sqlParameters = new ArrayList<SqlParameter>();
        String modifiedExpandedQuery = expandedQuery.toLowerCase(Locale.US).replaceAll("\\s+", "");
        for (int paramIndex = 0; paramIndex < parameters.length; ++paramIndex) {
            Parameter queryParam = this.getQueryMethod().getParameters().getParameter(paramIndex);
            String paramName = queryParam.getName().orElse("");
            if ("".equals(paramName)) continue;
            String inParamCheck = "array_contains(@" + paramName.toLowerCase(Locale.US);
            if (parameters[paramIndex] instanceof Collection && !modifiedExpandedQuery.contains(inParamCheck)) {
                List expandParam = ((Collection)parameters[paramIndex]).stream().collect(Collectors.toList());
                ArrayList<String> expandedParamKeys = new ArrayList<String>();
                for (int arrayIndex = 0; arrayIndex < expandParam.size(); ++arrayIndex) {
                    expandedParamKeys.add("@" + paramName + arrayIndex);
                    sqlParameters.add(new SqlParameter("@" + paramName + arrayIndex, MappingCosmosConverter.toCosmosDbValue(expandParam.get(arrayIndex))));
                }
                expandedQuery = expandedQuery.replaceAll("@" + queryParam.getName().orElse(""), String.join((CharSequence)",", expandedParamKeys));
                continue;
            }
            if (Pageable.class.isAssignableFrom(queryParam.getType()) || Sort.class.isAssignableFrom(queryParam.getType()) || parameters[paramIndex] instanceof Optional && (!(parameters[paramIndex] instanceof Optional) || !((Optional)parameters[paramIndex]).isPresent())) continue;
            sqlParameters.add(new SqlParameter("@" + queryParam.getName().orElse(""), MappingCosmosConverter.toCosmosDbValue(parameters[paramIndex])));
        }
        SqlQuerySpec querySpec = new SqlQuerySpec(expandedQuery, sqlParameters);
        if (this.isPageQuery()) {
            return this.operations.runPaginationQuery(querySpec, accessor.getPageable(), processor.getReturnedType().getDomainType(), processor.getReturnedType().getReturnedType());
        }
        if (this.isSliceQuery()) {
            return this.operations.runSliceQuery(querySpec, accessor.getPageable(), processor.getReturnedType().getDomainType(), processor.getReturnedType().getReturnedType());
        }
        if (this.isCountQuery()) {
            String container = ((CosmosEntityMetadata)this.getQueryMethod().getEntityInformation()).getContainerName();
            return this.operations.count(querySpec, container);
        }
        return this.operations.runQuery(querySpec, accessor.getSort(), processor.getReturnedType().getDomainType(), processor.getReturnedType().getReturnedType());
    }

    @Override
    protected boolean isDeleteQuery() {
        return false;
    }

    @Override
    protected boolean isExistsQuery() {
        return false;
    }

    @Override
    protected boolean isCountQuery() {
        return StringBasedCosmosQuery.isCountQuery(this.query, this.getQueryMethod().getReturnedObjectType());
    }

    static boolean isCountQuery(String query, Class<?> returnedType) {
        if (StringBasedCosmosQuery.isCountQueryReturnType(returnedType)) {
            return COUNT_QUERY_PATTERN.matcher(query).matches();
        }
        return false;
    }

    private static boolean isCountQueryReturnType(Class<?> returnedType) {
        return returnedType == Long.class || returnedType == Long.TYPE || returnedType == Integer.class || returnedType == Integer.TYPE;
    }
}

