/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.repository.query;

import com.azure.spring.data.cosmos.core.CosmosOperations;
import com.azure.spring.data.cosmos.core.query.CosmosQuery;
import com.azure.spring.data.cosmos.repository.query.CosmosEntityMetadata;
import com.azure.spring.data.cosmos.repository.query.CosmosParameterAccessor;
import com.azure.spring.data.cosmos.repository.query.CosmosParameterParameterAccessor;
import com.azure.spring.data.cosmos.repository.query.CosmosQueryExecution;
import com.azure.spring.data.cosmos.repository.query.CosmosQueryMethod;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;

public abstract class AbstractCosmosQuery
implements RepositoryQuery {
    private final CosmosQueryMethod method;
    protected final CosmosOperations operations;

    public AbstractCosmosQuery(CosmosQueryMethod method, CosmosOperations operations) {
        this.method = method;
        this.operations = operations;
    }

    public Object execute(Object[] parameters) {
        CosmosParameterParameterAccessor accessor = new CosmosParameterParameterAccessor(this.method, parameters);
        CosmosQuery query = this.createQuery(accessor);
        ResultProcessor processor = this.method.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        String container = ((CosmosEntityMetadata)this.method.getEntityInformation()).getContainerName();
        CosmosQueryExecution execution = this.getExecution(accessor, processor.getReturnedType());
        return execution.execute(query, processor.getReturnedType().getDomainType(), container);
    }

    protected CosmosQueryExecution getExecution(CosmosParameterAccessor accessor, ReturnedType returnedType) {
        if (this.isDeleteQuery()) {
            return new CosmosQueryExecution.DeleteExecution(this.operations);
        }
        if (this.isPageQuery()) {
            return new CosmosQueryExecution.PagedExecution(this.operations, accessor.getPageable());
        }
        if (this.isExistsQuery()) {
            return new CosmosQueryExecution.ExistsExecution(this.operations);
        }
        if (this.isCollectionQuery()) {
            return new CosmosQueryExecution.MultiEntityExecution(this.operations);
        }
        return new CosmosQueryExecution.SingleEntityExecution(this.operations, returnedType);
    }

    public CosmosQueryMethod getQueryMethod() {
        return this.method;
    }

    protected abstract CosmosQuery createQuery(CosmosParameterAccessor var1);

    protected abstract boolean isDeleteQuery();

    protected abstract boolean isExistsQuery();

    protected boolean isPageQuery() {
        return this.method.isPageQuery();
    }

    protected boolean isCollectionQuery() {
        return this.method.isCollectionQuery();
    }
}

