/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.repository.query;

import com.azure.spring.data.cosmos.core.ReactiveCosmosOperations;
import com.azure.spring.data.cosmos.core.mapping.CosmosPersistentProperty;
import com.azure.spring.data.cosmos.core.query.CosmosQuery;
import com.azure.spring.data.cosmos.repository.query.AbstractReactiveCosmosQuery;
import com.azure.spring.data.cosmos.repository.query.ReactiveCosmosParameterAccessor;
import com.azure.spring.data.cosmos.repository.query.ReactiveCosmosQueryCreator;
import com.azure.spring.data.cosmos.repository.query.ReactiveCosmosQueryMethod;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeReactiveCosmosQuery
extends AbstractReactiveCosmosQuery {
    private final PartTree tree;
    private final MappingContext<?, CosmosPersistentProperty> mappingContext;
    private final ResultProcessor processor;

    public PartTreeReactiveCosmosQuery(ReactiveCosmosQueryMethod method, ReactiveCosmosOperations operations) {
        super(method, operations);
        this.processor = method.getResultProcessor();
        this.tree = new PartTree(method.getName(), this.processor.getReturnedType().getDomainType());
        this.mappingContext = operations.getConverter().getMappingContext();
    }

    @Override
    protected CosmosQuery createQuery(ReactiveCosmosParameterAccessor accessor) {
        ReactiveCosmosQueryCreator creator = new ReactiveCosmosQueryCreator(this.tree, accessor, this.mappingContext);
        CosmosQuery query = (CosmosQuery)creator.createQuery();
        if (this.tree.isLimiting()) {
            throw new UnsupportedOperationException("Limiting is not supported.");
        }
        return query;
    }

    @Override
    protected boolean isDeleteQuery() {
        return this.tree.isDelete();
    }

    @Override
    protected boolean isExistsQuery() {
        return this.tree.isExistsProjection();
    }
}

