/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.repository.support;

import com.azure.cosmos.CosmosException;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.PartitionKey;
import com.azure.spring.data.cosmos.core.CosmosOperations;
import com.azure.spring.data.cosmos.core.query.CosmosQuery;
import com.azure.spring.data.cosmos.core.query.Criteria;
import com.azure.spring.data.cosmos.core.query.CriteriaType;
import com.azure.spring.data.cosmos.repository.CosmosRepository;
import com.azure.spring.data.cosmos.repository.support.CosmosEntityInformation;
import com.azure.spring.data.cosmos.repository.support.IndexPolicyCompareService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SimpleCosmosRepository<T, ID extends Serializable>
implements CosmosRepository<T, ID> {
    private final CosmosOperations operation;
    private final CosmosEntityInformation<T, ID> information;

    public SimpleCosmosRepository(CosmosEntityInformation<T, ID> metadata, CosmosOperations dbOperations) {
        CosmosContainerProperties currentProperties;
        this.operation = dbOperations;
        this.information = metadata;
        if (this.information.isAutoCreateContainer()) {
            this.createContainerIfNotExists();
        }
        if ((currentProperties = this.getContainerProperties()) != null && IndexPolicyCompareService.policyNeedsUpdate(currentProperties.getIndexingPolicy(), this.information.getIndexingPolicy())) {
            currentProperties.setIndexingPolicy(this.information.getIndexingPolicy());
            this.replaceContainerProperties(currentProperties);
        }
    }

    private CosmosContainerProperties getContainerProperties() {
        try {
            return this.operation.getContainerProperties(this.information.getContainerName());
        }
        catch (CosmosException ex) {
            if (ex.getStatusCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    private CosmosContainerProperties replaceContainerProperties(CosmosContainerProperties properties) {
        return this.operation.replaceContainerProperties(this.information.getContainerName(), properties);
    }

    private CosmosContainerProperties createContainerIfNotExists() {
        return this.operation.createContainerIfNotExists(this.information);
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"entity must not be null");
        if (this.information.isNew(entity)) {
            return this.operation.insert(this.information.getContainerName(), entity);
        }
        return this.operation.upsertAndReturnEntity(this.information.getContainerName(), entity);
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"Iterable entities should not be null");
        ArrayList savedEntities = new ArrayList();
        entities.forEach(entity -> {
            Object savedEntity = this.save(entity);
            savedEntities.add(savedEntity);
        });
        return savedEntities;
    }

    public Iterable<T> findAll() {
        return this.operation.findAll(this.information.getContainerName(), this.information.getJavaType());
    }

    public Iterable<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"Iterable ids should not be null");
        return this.operation.findByIds(ids, this.information.getJavaType(), this.information.getContainerName());
    }

    public Optional<T> findById(ID id) {
        Assert.notNull(id, (String)"id must not be null");
        if (id instanceof String && !StringUtils.hasText((String)((String)id))) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.operation.findById(this.information.getContainerName(), id, this.information.getJavaType()));
    }

    @Override
    public Optional<T> findById(ID id, PartitionKey partitionKey) {
        Assert.notNull(id, (String)"id must not be null");
        if (id instanceof String && !StringUtils.hasText((String)((String)id))) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.operation.findById(id, this.information.getJavaType(), partitionKey));
    }

    public long count() {
        return this.operation.count(this.information.getContainerName());
    }

    public void deleteById(ID id) {
        Assert.notNull(id, (String)"id to be deleted should not be null");
        this.operation.deleteById(this.information.getContainerName(), id, null);
    }

    @Override
    public void deleteById(ID id, PartitionKey partitionKey) {
        Assert.notNull(id, (String)"id to be deleted should not be null");
        Assert.notNull((Object)partitionKey, (String)"partitionKey to be deleted should not be null");
        this.operation.deleteById(this.information.getContainerName(), id, partitionKey);
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"entity to be deleted should not be null");
        this.operation.deleteEntity(this.information.getContainerName(), entity);
    }

    public void deleteAll() {
        this.operation.deleteAll(this.information.getContainerName(), this.information.getJavaType());
    }

    public void deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"Iterable entities should not be null");
        StreamSupport.stream(entities.spliterator(), true).forEach(this::delete);
    }

    public boolean existsById(ID primaryKey) {
        Assert.notNull(primaryKey, (String)"primaryKey should not be null");
        return this.findById(primaryKey).isPresent();
    }

    public Iterable<T> findAll(@NonNull Sort sort) {
        Assert.notNull((Object)sort, (String)"sort of findAll should not be null");
        CosmosQuery query = new CosmosQuery(Criteria.getInstance(CriteriaType.ALL)).with(sort);
        return this.operation.find(query, this.information.getJavaType(), this.information.getContainerName());
    }

    public Page<T> findAll(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"pageable should not be null");
        return this.operation.findAll(pageable, this.information.getJavaType(), this.information.getContainerName());
    }

    @Override
    public Iterable<T> findAll(PartitionKey partitionKey) {
        return this.operation.findAll(partitionKey, this.information.getJavaType());
    }
}

