/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.repository.support;

import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.spring.data.cosmos.core.ReactiveCosmosOperations;
import com.azure.spring.data.cosmos.core.convert.MappingCosmosConverter;
import com.azure.spring.data.cosmos.core.query.CosmosQuery;
import com.azure.spring.data.cosmos.repository.query.AbstractReactiveCosmosQuery;
import com.azure.spring.data.cosmos.repository.query.ReactiveCosmosParameterAccessor;
import com.azure.spring.data.cosmos.repository.query.ReactiveCosmosParameterParameterAccessor;
import com.azure.spring.data.cosmos.repository.query.ReactiveCosmosQueryMethod;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ResultProcessor;
import reactor.core.publisher.Flux;

public class StringBasedReactiveCosmosQuery
extends AbstractReactiveCosmosQuery {
    private final String query;

    public StringBasedReactiveCosmosQuery(ReactiveCosmosQueryMethod queryMethod, ReactiveCosmosOperations dbOperations) {
        super(queryMethod, dbOperations);
        this.query = queryMethod.getQueryAnnotation();
    }

    @Override
    protected CosmosQuery createQuery(ReactiveCosmosParameterAccessor accessor) {
        return null;
    }

    @Override
    public Object execute(Object[] parameters) {
        ReactiveCosmosParameterParameterAccessor accessor = new ReactiveCosmosParameterParameterAccessor(this.getQueryMethod(), parameters);
        ResultProcessor processor = this.getQueryMethod().getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        List sqlParameters = this.getQueryMethod().getParameters().stream().filter(p -> !Sort.class.isAssignableFrom(p.getType())).map(p -> new SqlParameter("@" + p.getName().orElse(""), MappingCosmosConverter.toCosmosDbValue(parameters[p.getIndex()]))).collect(Collectors.toList());
        SqlQuerySpec querySpec = new SqlQuerySpec(this.query, sqlParameters);
        Flux flux = this.operations.runQuery(querySpec, accessor.getSort(), processor.getReturnedType().getDomainType(), processor.getReturnedType().getReturnedType());
        return flux;
    }

    @Override
    protected boolean isDeleteQuery() {
        return false;
    }

    @Override
    protected boolean isExistsQuery() {
        return false;
    }
}

