/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.core;

import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.models.FeedResponse;

public class ResponseDiagnostics {
    private final CosmosDiagnostics cosmosDiagnostics;
    private final CosmosResponseStatistics cosmosResponseStatistics;

    public ResponseDiagnostics(CosmosDiagnostics cosmosDiagnostics, CosmosResponseStatistics cosmosResponseStatistics) {
        this.cosmosDiagnostics = cosmosDiagnostics;
        this.cosmosResponseStatistics = cosmosResponseStatistics;
    }

    public CosmosDiagnostics getCosmosDiagnostics() {
        return this.cosmosDiagnostics;
    }

    public CosmosResponseStatistics getCosmosResponseStatistics() {
        return this.cosmosResponseStatistics;
    }

    public String toString() {
        StringBuilder diagnostics = new StringBuilder();
        if (this.cosmosDiagnostics != null) {
            diagnostics.append("cosmosResponseDiagnostics={").append(this.cosmosDiagnostics).append("}");
        }
        if (this.cosmosResponseStatistics != null) {
            if (diagnostics.length() != 0) {
                diagnostics.append(", ");
            }
            diagnostics.append("cosmosResponseStatistics={").append(this.cosmosResponseStatistics).append("}");
        }
        return diagnostics.toString();
    }

    public static class CosmosResponseStatistics {
        private final double requestCharge;
        private final String activityId;

        public <T> CosmosResponseStatistics(FeedResponse<T> feedResponse) {
            this.requestCharge = feedResponse.getRequestCharge();
            this.activityId = feedResponse.getActivityId();
        }

        public double getRequestCharge() {
            return this.requestCharge;
        }

        public String getActivityId() {
            return this.activityId;
        }

        public String toString() {
            return "CosmosResponseStatistics{requestCharge=" + this.requestCharge + ",activityId='" + this.activityId + '\'' + '}';
        }
    }
}

