/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.repository.query;

import com.azure.spring.data.cosmos.core.ReactiveCosmosOperations;
import com.azure.spring.data.cosmos.core.query.CosmosQuery;
import com.azure.spring.data.cosmos.repository.query.ReactiveCosmosEntityMetadata;
import com.azure.spring.data.cosmos.repository.query.ReactiveCosmosParameterAccessor;
import com.azure.spring.data.cosmos.repository.query.ReactiveCosmosParameterParameterAccessor;
import com.azure.spring.data.cosmos.repository.query.ReactiveCosmosQueryExecution;
import com.azure.spring.data.cosmos.repository.query.ReactiveCosmosQueryMethod;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import reactor.core.publisher.Mono;

public abstract class AbstractReactiveCosmosQuery
implements RepositoryQuery {
    private final ReactiveCosmosQueryMethod method;
    protected final ReactiveCosmosOperations operations;

    public AbstractReactiveCosmosQuery(ReactiveCosmosQueryMethod method, ReactiveCosmosOperations operations) {
        this.method = method;
        this.operations = operations;
    }

    public Object execute(Object[] parameters) {
        ReactiveCosmosParameterParameterAccessor accessor = new ReactiveCosmosParameterParameterAccessor(this.method, parameters);
        CosmosQuery query = this.createQuery(accessor);
        ResultProcessor processor = this.method.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        String containerName = ((ReactiveCosmosEntityMetadata)this.method.getEntityInformation()).getContainerName();
        ReactiveCosmosQueryExecution execution = this.getExecution(processor.getReturnedType());
        return execution.execute(query, processor.getReturnedType().getDomainType(), containerName);
    }

    protected ReactiveCosmosQueryExecution getExecution(ReturnedType returnedType) {
        if (this.isDeleteQuery()) {
            return new ReactiveCosmosQueryExecution.DeleteExecution(this.operations);
        }
        if (this.isPageQuery()) {
            throw new IllegalArgumentException("Paged Query is not supported by reactive cosmos db");
        }
        if (this.isExistsQuery()) {
            return new ReactiveCosmosQueryExecution.ExistsExecution(this.operations);
        }
        if (this.isReactiveSingleResultQuery()) {
            return new ReactiveCosmosQueryExecution.SingleEntityExecution(this.operations, returnedType);
        }
        return new ReactiveCosmosQueryExecution.MultiEntityExecution(this.operations);
    }

    public ReactiveCosmosQueryMethod getQueryMethod() {
        return this.method;
    }

    protected abstract CosmosQuery createQuery(ReactiveCosmosParameterAccessor var1);

    protected abstract boolean isDeleteQuery();

    protected abstract boolean isExistsQuery();

    protected boolean isPageQuery() {
        return this.method.isPageQuery();
    }

    private boolean isReactiveSingleResultQuery() {
        return this.method.getReactiveWrapper() != null && this.method.getReactiveWrapper().equals(Mono.class);
    }
}

