/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.repository.query;

import com.azure.spring.data.cosmos.core.CosmosOperations;
import com.azure.spring.data.cosmos.core.query.CosmosPageRequest;
import com.azure.spring.data.cosmos.core.query.CosmosQuery;
import com.azure.spring.data.cosmos.exception.CosmosAccessException;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.query.ReturnedType;

public interface CosmosQueryExecution {
    public Object execute(CosmosQuery var1, Class<?> var2, String var3);

    public static final class SliceExecution
    implements CosmosQueryExecution {
        private final CosmosOperations operations;
        private final Pageable pageable;

        public SliceExecution(CosmosOperations operations, Pageable pageable) {
            this.operations = operations;
            this.pageable = pageable;
        }

        @Override
        public Object execute(CosmosQuery query, Class<?> type, String container) {
            if (this.pageable.getPageNumber() != 0 && !(this.pageable instanceof CosmosPageRequest)) {
                throw new IllegalStateException("Not the first page but Pageable is not a valid CosmosPageRequest, requestContinuation is required for non first page request");
            }
            query.with(this.pageable);
            return this.operations.sliceQuery(query, type, container);
        }
    }

    public static final class PagedExecution
    implements CosmosQueryExecution {
        private final CosmosOperations operations;
        private final Pageable pageable;

        public PagedExecution(CosmosOperations operations, Pageable pageable) {
            this.operations = operations;
            this.pageable = pageable;
        }

        @Override
        public Object execute(CosmosQuery query, Class<?> type, String container) {
            if (this.pageable.getPageNumber() != 0 && !(this.pageable instanceof CosmosPageRequest)) {
                throw new IllegalStateException("Not the first page but Pageable is not a valid CosmosPageRequest, requestContinuation is required for non first page request");
            }
            query.with(this.pageable);
            return this.operations.paginationQuery(query, type, container);
        }
    }

    public static final class DeleteExecution
    implements CosmosQueryExecution {
        private final CosmosOperations operations;

        public DeleteExecution(CosmosOperations operations) {
            this.operations = operations;
        }

        @Override
        public Object execute(CosmosQuery query, Class<?> type, String container) {
            return this.operations.delete(query, type, container);
        }
    }

    public static final class ExistsExecution
    implements CosmosQueryExecution {
        private final CosmosOperations operations;

        public ExistsExecution(CosmosOperations operations) {
            this.operations = operations;
        }

        @Override
        public Object execute(CosmosQuery query, Class<?> type, String container) {
            return this.operations.exists(query, type, container);
        }
    }

    public static final class SingleEntityExecution
    implements CosmosQueryExecution {
        private final CosmosOperations operations;
        private final ReturnedType returnedType;

        public SingleEntityExecution(CosmosOperations operations, ReturnedType returnedType) {
            this.operations = operations;
            this.returnedType = returnedType;
        }

        @Override
        public Object execute(CosmosQuery query, Class<?> type, String collection) {
            Object result;
            Iterable<?> resultsIterable = this.operations.find(query, type, collection);
            ArrayList results = new ArrayList();
            resultsIterable.forEach(results::add);
            if (results.isEmpty()) {
                result = null;
            } else if (results.size() == 1) {
                result = results.get(0);
            } else {
                throw new CosmosAccessException("Too many results - return type " + this.returnedType.getReturnedType() + " is not of type Iterable but find returned " + results.size() + " results");
            }
            if (this.returnedType.getReturnedType() == Optional.class) {
                return result == null ? Optional.empty() : Optional.of(result);
            }
            return result;
        }
    }

    public static final class MultiEntityExecution
    implements CosmosQueryExecution {
        private final CosmosOperations operations;

        public MultiEntityExecution(CosmosOperations operations) {
            this.operations = operations;
        }

        @Override
        public Object execute(CosmosQuery query, Class<?> type, String container) {
            return this.operations.find(query, type, container);
        }
    }

    public static final class ContainerExecution
    implements CosmosQueryExecution {
        private final CosmosOperations operations;

        public ContainerExecution(CosmosOperations operations) {
            this.operations = operations;
        }

        @Override
        public Object execute(CosmosQuery query, Class<?> type, String container) {
            return this.operations.getContainerName(type);
        }
    }
}

