/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.repository.support;

import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.spring.data.cosmos.core.CosmosOperations;
import com.azure.spring.data.cosmos.core.convert.MappingCosmosConverter;
import com.azure.spring.data.cosmos.core.query.CosmosQuery;
import com.azure.spring.data.cosmos.repository.query.AbstractCosmosQuery;
import com.azure.spring.data.cosmos.repository.query.CosmosParameterAccessor;
import com.azure.spring.data.cosmos.repository.query.CosmosParameterParameterAccessor;
import com.azure.spring.data.cosmos.repository.query.CosmosQueryMethod;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ResultProcessor;

public class StringBasedCosmosQuery
extends AbstractCosmosQuery {
    private final String query;

    public StringBasedCosmosQuery(CosmosQueryMethod queryMethod, CosmosOperations dbOperations) {
        super(queryMethod, dbOperations);
        this.query = queryMethod.getQueryAnnotation();
    }

    @Override
    protected CosmosQuery createQuery(CosmosParameterAccessor accessor) {
        return null;
    }

    @Override
    public Object execute(Object[] parameters) {
        CosmosParameterParameterAccessor accessor = new CosmosParameterParameterAccessor(this.getQueryMethod(), parameters);
        ResultProcessor processor = this.getQueryMethod().getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        List sqlParameters = this.getQueryMethod().getParameters().stream().filter(p -> !Pageable.class.isAssignableFrom(p.getType()) && !Sort.class.isAssignableFrom(p.getType())).map(p -> new SqlParameter("@" + p.getName().orElse(""), MappingCosmosConverter.toCosmosDbValue(parameters[p.getIndex()]))).collect(Collectors.toList());
        SqlQuerySpec querySpec = new SqlQuerySpec(this.query, sqlParameters);
        if (this.isPageQuery()) {
            return this.operations.runPaginationQuery(querySpec, accessor.getPageable(), processor.getReturnedType().getDomainType(), processor.getReturnedType().getReturnedType());
        }
        return this.operations.runQuery(querySpec, accessor.getSort(), processor.getReturnedType().getDomainType(), processor.getReturnedType().getReturnedType());
    }

    @Override
    protected boolean isDeleteQuery() {
        return false;
    }

    @Override
    protected boolean isExistsQuery() {
        return false;
    }
}

