/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.core.query;

import com.azure.spring.data.cosmos.core.query.Criteria;
import com.azure.spring.data.cosmos.core.query.CriteriaType;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class CosmosQuery {
    private final Criteria criteria;
    private Sort sort = Sort.unsorted();
    private Pageable pageable = Pageable.unpaged();
    private int limit;

    public CosmosQuery(@NonNull Criteria criteria) {
        this.criteria = criteria;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public Sort getSort() {
        return this.sort;
    }

    public Pageable getPageable() {
        return this.pageable;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        if (this.limit == 0) {
            this.limit = limit;
        }
    }

    public CosmosQuery with(@NonNull Sort sort) {
        if (sort.isSorted()) {
            this.sort = sort.and(this.sort);
        }
        return this;
    }

    public CosmosQuery with(@NonNull Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"pageable should not be null");
        this.pageable = pageable;
        return this;
    }

    private boolean isCrossPartitionQuery(@NonNull String keyName) {
        Assert.hasText((String)keyName, (String)"PartitionKey should have text.");
        Optional<Criteria> criteria = this.getSubjectCriteria(this.criteria, keyName);
        return criteria.map(criteria1 -> criteria1.getType() != CriteriaType.IS_EQUAL).orElse(true);
    }

    private boolean hasKeywordOr() {
        return this.criteria.getType() == CriteriaType.OR;
    }

    public boolean isCrossPartitionQuery(@NonNull List<String> partitionKeys) {
        if (partitionKeys.isEmpty()) {
            return true;
        }
        return partitionKeys.stream().filter(this::isCrossPartitionQuery).findFirst().map(p -> true).orElse(this.hasKeywordOr());
    }

    public Optional<Criteria> getCriteriaByType(@NonNull CriteriaType criteriaType) {
        return this.getCriteriaByType(criteriaType, this.criteria);
    }

    private Optional<Criteria> getCriteriaByType(@NonNull CriteriaType criteriaType, @NonNull Criteria criteria) {
        if (criteria.getType().equals((Object)criteriaType)) {
            return Optional.of(criteria);
        }
        for (Criteria subCriteria : criteria.getSubCriteria()) {
            if (!this.getCriteriaByType(criteriaType, subCriteria).isPresent()) continue;
            return Optional.of(subCriteria);
        }
        return Optional.empty();
    }

    private Optional<Criteria> getSubjectCriteria(@NonNull Criteria criteria, @NonNull String keyName) {
        if (keyName.equals(criteria.getSubject())) {
            return Optional.of(criteria);
        }
        List<Criteria> subCriteriaList = criteria.getSubCriteria();
        for (Criteria c : subCriteriaList) {
            Optional<Criteria> subjectCriteria = this.getSubjectCriteria(c, keyName);
            if (!subjectCriteria.isPresent()) continue;
            return subjectCriteria;
        }
        return Optional.empty();
    }
}

