/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.core.query;

import com.azure.spring.data.cosmos.core.query.Criteria;
import com.azure.spring.data.cosmos.core.query.CriteriaType;
import com.azure.spring.data.cosmos.repository.support.CosmosEntityInformation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class CosmosQuery {
    private final Criteria criteria;
    private Sort sort = Sort.unsorted();
    private Pageable pageable = Pageable.unpaged();
    private int limit;

    public CosmosQuery(@NonNull Criteria criteria) {
        this.criteria = criteria;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public Sort getSort() {
        return this.sort;
    }

    public Pageable getPageable() {
        return this.pageable;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        if (this.limit == 0) {
            this.limit = limit;
        }
    }

    public CosmosQuery with(@NonNull Sort sort) {
        if (sort.isSorted()) {
            this.sort = sort.and(this.sort);
        }
        return this;
    }

    public CosmosQuery with(@NonNull Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"pageable should not be null");
        this.pageable = pageable;
        return this;
    }

    private boolean isCrossPartitionQuery(@NonNull String keyName) {
        Assert.hasText((String)keyName, (String)"PartitionKey should have text.");
        Optional<Criteria> criteria = this.getSubjectCriteria(this.criteria, keyName);
        return criteria.map(criteria1 -> {
            if (this.isEqualCriteria((Criteria)criteria1)) {
                return false;
            }
            if (criteria1.getType() == CriteriaType.IN && criteria1.getSubjectValues().size() == 1) {
                Collection collection = (Collection)criteria1.getSubjectValues().get(0);
                return collection.size() != 1;
            }
            return !this.hasKeywordAnd();
        }).orElse(true);
    }

    private boolean hasKeywordOr() {
        return this.criteria.getType() == CriteriaType.OR;
    }

    private boolean hasKeywordAnd() {
        return this.criteria.getType() == CriteriaType.AND;
    }

    private boolean isEqualCriteria(Criteria criteria) {
        return criteria.getType() == CriteriaType.IS_EQUAL;
    }

    public boolean isCrossPartitionQuery(@NonNull List<String> partitionKeys) {
        if (partitionKeys.isEmpty()) {
            return true;
        }
        return partitionKeys.stream().filter(this::isCrossPartitionQuery).findFirst().map(p -> true).orElse(this.hasKeywordOr());
    }

    public boolean hasPartitionKeyCriteria(@NonNull String partitionKeyFieldName) {
        if (partitionKeyFieldName.isEmpty()) {
            return false;
        }
        Optional<Criteria> criteria = this.getSubjectCriteria(this.criteria, partitionKeyFieldName);
        return criteria.isPresent();
    }

    public <T> Optional<Object> getPartitionKeyValue(@NonNull Class<T> domainType) {
        CosmosEntityInformation<T, T> instance = CosmosEntityInformation.getInstance(domainType);
        String partitionKeyFieldName = instance.getPartitionKeyFieldName();
        if (partitionKeyFieldName == null || partitionKeyFieldName.isEmpty() || this.isCrossPartitionQuery(Collections.singletonList(partitionKeyFieldName))) {
            return Optional.empty();
        }
        Optional<Criteria> criteria = this.getSubjectCriteria(this.criteria, partitionKeyFieldName);
        return criteria.map(criteria1 -> {
            if (!criteria1.getIgnoreCase().equals((Object)Part.IgnoreCaseType.NEVER)) {
                return null;
            }
            if (criteria1.getType() == CriteriaType.IN && criteria1.getSubjectValues().size() == 1) {
                Collection collection = (Collection)criteria1.getSubjectValues().get(0);
                if (collection.size() == 1) {
                    return collection.iterator().next();
                }
                return null;
            }
            return criteria1.getSubjectValues().get(0);
        });
    }

    public Optional<Criteria> getCriteriaByType(@NonNull CriteriaType criteriaType) {
        return this.getCriteriaByType(criteriaType, this.criteria);
    }

    private Optional<Criteria> getCriteriaByType(@NonNull CriteriaType criteriaType, @NonNull Criteria criteria) {
        if (criteria.getType().equals((Object)criteriaType)) {
            return Optional.of(criteria);
        }
        for (Criteria subCriteria : criteria.getSubCriteria()) {
            if (!this.getCriteriaByType(criteriaType, subCriteria).isPresent()) continue;
            return Optional.of(subCriteria);
        }
        return Optional.empty();
    }

    private Optional<Criteria> getSubjectCriteria(@NonNull Criteria criteria, @NonNull String keyName) {
        if (keyName.equals(criteria.getSubject())) {
            return Optional.of(criteria);
        }
        List<Criteria> subCriteriaList = criteria.getSubCriteria();
        for (Criteria c : subCriteriaList) {
            Optional<Criteria> subjectCriteria = this.getSubjectCriteria(c, keyName);
            if (!subjectCriteria.isPresent()) continue;
            return subjectCriteria;
        }
        return Optional.empty();
    }
}

