/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.repository.support;

import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.spring.data.cosmos.core.ReactiveCosmosOperations;
import com.azure.spring.data.cosmos.core.convert.MappingCosmosConverter;
import com.azure.spring.data.cosmos.core.query.CosmosQuery;
import com.azure.spring.data.cosmos.repository.query.AbstractReactiveCosmosQuery;
import com.azure.spring.data.cosmos.repository.query.ReactiveCosmosParameterAccessor;
import com.azure.spring.data.cosmos.repository.query.ReactiveCosmosParameterParameterAccessor;
import com.azure.spring.data.cosmos.repository.query.ReactiveCosmosQueryMethod;
import com.azure.spring.data.cosmos.repository.query.SimpleReactiveCosmosEntityMetadata;
import com.azure.spring.data.cosmos.repository.support.StringBasedCosmosQuery;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ResultProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class StringBasedReactiveCosmosQuery
extends AbstractReactiveCosmosQuery {
    private final String query;

    public StringBasedReactiveCosmosQuery(ReactiveCosmosQueryMethod queryMethod, ReactiveCosmosOperations dbOperations) {
        super(queryMethod, dbOperations);
        this.query = queryMethod.getQueryAnnotation();
    }

    @Override
    protected CosmosQuery createQuery(ReactiveCosmosParameterAccessor accessor) {
        return null;
    }

    @Override
    public Object execute(Object[] parameters) {
        ReactiveCosmosParameterParameterAccessor accessor = new ReactiveCosmosParameterParameterAccessor(this.getQueryMethod(), parameters);
        ResultProcessor processor = this.getQueryMethod().getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        String expandedQuery = this.query;
        ArrayList<SqlParameter> sqlParameters = new ArrayList<SqlParameter>();
        String modifiedExpandedQuery = expandedQuery.toLowerCase(Locale.US).replaceAll("\\s+", "");
        for (int paramIndex = 0; paramIndex < parameters.length; ++paramIndex) {
            Parameter queryParam = this.getQueryMethod().getParameters().getParameter(paramIndex);
            String paramName = queryParam.getName().orElse("");
            if ("".equals(paramName)) continue;
            String inParamCheck = "array_contains(@" + paramName.toLowerCase(Locale.US);
            if (parameters[paramIndex] instanceof Collection && !modifiedExpandedQuery.contains(inParamCheck)) {
                List expandParam = ((Collection)parameters[paramIndex]).stream().collect(Collectors.toList());
                ArrayList<CallSite> expandedParamKeys = new ArrayList<CallSite>();
                for (int arrayIndex = 0; arrayIndex < expandParam.size(); ++arrayIndex) {
                    expandedParamKeys.add((CallSite)((Object)("@" + paramName + arrayIndex)));
                    sqlParameters.add(new SqlParameter("@" + paramName + arrayIndex, MappingCosmosConverter.toCosmosDbValue(expandParam.get(arrayIndex))));
                }
                expandedQuery = expandedQuery.replaceAll("@" + queryParam.getName().orElse(""), String.join((CharSequence)",", expandedParamKeys));
                continue;
            }
            if (Pageable.class.isAssignableFrom(queryParam.getType()) || Sort.class.isAssignableFrom(queryParam.getType()) || parameters[paramIndex] instanceof Optional && (!(parameters[paramIndex] instanceof Optional) || !((Optional)parameters[paramIndex]).isPresent())) continue;
            sqlParameters.add(new SqlParameter("@" + queryParam.getName().orElse(""), MappingCosmosConverter.toCosmosDbValue(parameters[paramIndex])));
        }
        SqlQuerySpec querySpec = new SqlQuerySpec(this.stripExtraWhitespaceFromString(expandedQuery), sqlParameters);
        if (this.isCountQuery()) {
            String container = ((SimpleReactiveCosmosEntityMetadata)this.getQueryMethod().getEntityInformation()).getContainerName();
            Mono<Long> mono = this.operations.count(querySpec, container);
            return mono;
        }
        Flux flux = this.operations.runQuery(querySpec, accessor.getSort(), processor.getReturnedType().getDomainType(), processor.getReturnedType().getReturnedType());
        return flux;
    }

    private String stripExtraWhitespaceFromString(String input) {
        return input.replaceAll("\\s+{1,}", " ").trim();
    }

    @Override
    protected boolean isDeleteQuery() {
        return false;
    }

    @Override
    protected boolean isExistsQuery() {
        return false;
    }

    @Override
    protected boolean isCountQuery() {
        return StringBasedCosmosQuery.isCountQuery(this.query, this.getQueryMethod().getReturnedObjectType());
    }
}

