/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.repository.query;

import com.azure.spring.data.cosmos.core.ReactiveCosmosOperations;
import com.azure.spring.data.cosmos.core.query.CosmosQuery;
import com.azure.spring.data.cosmos.exception.CosmosAccessException;
import org.springframework.data.repository.query.ReturnedType;

public interface ReactiveCosmosQueryExecution {
    public Object execute(CosmosQuery var1, Class<?> var2, String var3);

    public static final class CountExecution
    implements ReactiveCosmosQueryExecution {
        private final ReactiveCosmosOperations operations;

        public CountExecution(ReactiveCosmosOperations operations) {
            this.operations = operations;
        }

        @Override
        public Object execute(CosmosQuery query, Class<?> type, String container) {
            return this.operations.count(query, container);
        }
    }

    public static final class DeleteExecution
    implements ReactiveCosmosQueryExecution {
        private final ReactiveCosmosOperations operations;

        public DeleteExecution(ReactiveCosmosOperations operations) {
            this.operations = operations;
        }

        @Override
        public Object execute(CosmosQuery query, Class<?> type, String container) {
            return this.operations.delete(query, type, container);
        }
    }

    public static final class ExistsExecution
    implements ReactiveCosmosQueryExecution {
        private final ReactiveCosmosOperations operations;

        public ExistsExecution(ReactiveCosmosOperations operations) {
            this.operations = operations;
        }

        @Override
        public Object execute(CosmosQuery query, Class<?> type, String container) {
            return this.operations.exists(query, type, container);
        }
    }

    public static final class SingleEntityExecution
    implements ReactiveCosmosQueryExecution {
        private final ReactiveCosmosOperations operations;
        private final ReturnedType returnedType;

        public SingleEntityExecution(ReactiveCosmosOperations operations, ReturnedType returnedType) {
            this.operations = operations;
            this.returnedType = returnedType;
        }

        @Override
        public Object execute(CosmosQuery query, Class<?> type, String container) {
            return this.operations.find(query, type, container).buffer(2).map(vals -> {
                if (vals.size() > 1) {
                    throw new CosmosAccessException("Too many results - Expected Mono<" + String.valueOf(this.returnedType.getReturnedType()) + "> but query returned multiple results");
                }
                return vals.iterator().next();
            });
        }
    }

    public static final class MultiEntityExecution
    implements ReactiveCosmosQueryExecution {
        private final ReactiveCosmosOperations operations;

        public MultiEntityExecution(ReactiveCosmosOperations operations) {
            this.operations = operations;
        }

        @Override
        public Object execute(CosmosQuery query, Class<?> type, String container) {
            return this.operations.find(query, type, container);
        }
    }

    public static final class ContainerExecution
    implements ReactiveCosmosQueryExecution {
        private final ReactiveCosmosOperations operations;

        public ContainerExecution(ReactiveCosmosOperations operations) {
            this.operations = operations;
        }

        @Override
        public Object execute(CosmosQuery query, Class<?> type, String container) {
            return this.operations.getContainerName(type);
        }
    }
}

