/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos;

import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosClientBuilder;
import com.azure.spring.data.cosmos.common.PropertyLoader;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class CosmosFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(CosmosFactory.class);
    private final CosmosAsyncClient cosmosAsyncClient;
    protected String databaseName;
    private static final String USER_AGENT_SUFFIX = "az-sd-cos/" + PropertyLoader.getProjectVersion();

    private static String getUserAgentSuffix() {
        return USER_AGENT_SUFFIX;
    }

    public CosmosFactory(CosmosAsyncClient cosmosAsyncClient, String databaseName) {
        Assert.notNull((Object)cosmosAsyncClient, (String)"cosmosAsyncClient must not be null!");
        Assert.notNull((Object)databaseName, (String)"databaseName must not be null!");
        this.cosmosAsyncClient = cosmosAsyncClient;
        this.databaseName = databaseName;
    }

    public CosmosAsyncClient getCosmosAsyncClient() {
        return this.cosmosAsyncClient;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String overrideContainerName() {
        return null;
    }

    public static CosmosAsyncClient createCosmosAsyncClient(CosmosClientBuilder cosmosClientBuilder) {
        return CosmosFactory.updateCosmosClientBuilderWithUASuffix(cosmosClientBuilder).buildAsyncClient();
    }

    private static CosmosClientBuilder updateCosmosClientBuilderWithUASuffix(CosmosClientBuilder cosmosClientBuilder) {
        cosmosClientBuilder.contentResponseOnWriteEnabled(true);
        String userAgentSuffixValue = CosmosFactory.getUserAgentSuffixValue(cosmosClientBuilder);
        Object userAgentSuffix = CosmosFactory.getUserAgentSuffix();
        if (!userAgentSuffixValue.contains((CharSequence)userAgentSuffix)) {
            userAgentSuffix = (String)userAgentSuffix + userAgentSuffixValue;
        }
        return cosmosClientBuilder.userAgentSuffix((String)userAgentSuffix);
    }

    private static String getUserAgentSuffixValue(CosmosClientBuilder cosmosClientBuilder) {
        try {
            Field userAgentSuffixField = cosmosClientBuilder.getClass().getDeclaredField("userAgentSuffix");
            userAgentSuffixField.setAccessible(true);
            return (String)userAgentSuffixField.get(cosmosClientBuilder);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error("Error occurred while getting userAgentSuffix from CosmosClientBuilder", (Throwable)e);
            return "";
        }
    }
}

