/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.core.generator;

import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.spring.data.cosmos.core.generator.AbstractQueryGenerator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;

public class NativeQueryGenerator {
    private static final NativeQueryGenerator INSTANCE = new NativeQueryGenerator();

    public static NativeQueryGenerator getInstance() {
        return INSTANCE;
    }

    private SqlQuerySpec cloneWithQueryText(SqlQuerySpec querySpec, String queryText) {
        SqlQuerySpec clone = new SqlQuerySpec();
        clone.setQueryText(queryText);
        clone.setParameters(querySpec.getParameters());
        return clone;
    }

    public SqlQuerySpec generateSortedQuery(SqlQuerySpec querySpec, Sort sort) {
        if (sort == null || sort.isUnsorted()) {
            return querySpec;
        }
        Matcher matcher = Pattern.compile("\\s(?i)from\\s").matcher(querySpec.getQueryText());
        matcher.find();
        int beginIndex = matcher.start(0) + 6;
        String tableName = querySpec.getQueryText().substring(beginIndex);
        tableName = tableName.substring(0, tableName.indexOf(" "));
        String querySort = AbstractQueryGenerator.generateQuerySort(sort, tableName);
        String queryText = querySpec.getQueryText() + " " + querySort;
        return this.cloneWithQueryText(querySpec, queryText);
    }

    public SqlQuerySpec generateCountQuery(SqlQuerySpec querySpec) {
        String queryText = querySpec.getQueryText();
        int fromIndex = queryText.toLowerCase(Locale.US).indexOf(" from ");
        Assert.isTrue((fromIndex >= 0 ? 1 : 0) != 0, (String)("query missing from keyword, query=" + queryText));
        String countQueryText = "select value count(1) " + queryText.substring(fromIndex);
        return this.cloneWithQueryText(querySpec, countQueryText);
    }
}

