/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.batch;

import com.azure.core.http.HttpRequest;
import com.azure.core.util.CoreUtils;
import com.azure.storage.blob.batch.BlobBatchOperationResponse;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

final class BlobBatchOperationInfo {
    private static final String X_MS_VERSION = "x-ms-version";
    private static final String BATCH_BOUNDARY_TEMPLATE = "batch_%s";
    private static final String REQUEST_CONTENT_TYPE_TEMPLATE = "multipart/mixed; boundary=%s";
    private static final String BATCH_OPERATION_CONTENT_TYPE = "Content-Type: application/http";
    private static final String BATCH_OPERATION_CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding: binary";
    private static final String BATCH_OPERATION_CONTENT_ID_TEMPLATE = "Content-ID: %d";
    private static final String HTTP_VERSION = "HTTP/1.1";
    private static final String OPERATION_TEMPLATE = "%s %s %s";
    private static final String HEADER_TEMPLATE = "%s: %s";
    private final AtomicInteger contentId = new AtomicInteger();
    private final String batchBoundary = String.format("batch_%s", UUID.randomUUID());
    private final String contentType = String.format("multipart/mixed; boundary=%s", this.batchBoundary);
    private final Collection<ByteBuffer> batchOperations = new ConcurrentLinkedQueue<ByteBuffer>();
    private final Map<Integer, BlobBatchOperationResponse<?>> batchOperationResponseMap = new ConcurrentHashMap();

    BlobBatchOperationInfo() {
    }

    Collection<ByteBuffer> getBody() {
        return this.batchOperations;
    }

    long getContentLength() {
        return this.batchOperations.stream().map(buffer -> buffer.remaining()).reduce(0L, Long::sum);
    }

    String getContentType() {
        return this.contentType;
    }

    void addBatchOperation(BlobBatchOperationResponse<?> batchOperation, HttpRequest request) {
        int contentId = this.contentId.getAndIncrement();
        StringBuilder batchRequestBuilder = new StringBuilder();
        BlobBatchOperationInfo.appendWithNewline(batchRequestBuilder, "--" + this.batchBoundary);
        BlobBatchOperationInfo.appendWithNewline(batchRequestBuilder, BATCH_OPERATION_CONTENT_TYPE);
        BlobBatchOperationInfo.appendWithNewline(batchRequestBuilder, BATCH_OPERATION_CONTENT_TRANSFER_ENCODING);
        BlobBatchOperationInfo.appendWithNewline(batchRequestBuilder, String.format(BATCH_OPERATION_CONTENT_ID_TEMPLATE, contentId));
        batchRequestBuilder.append("\r\n");
        String method = request.getHttpMethod().toString();
        String urlPath = request.getUrl().getPath();
        String urlQuery = request.getUrl().getQuery();
        if (!CoreUtils.isNullOrEmpty((CharSequence)urlQuery)) {
            urlPath = urlPath + "?" + urlQuery;
        }
        BlobBatchOperationInfo.appendWithNewline(batchRequestBuilder, String.format(OPERATION_TEMPLATE, method, urlPath, HTTP_VERSION));
        request.getHeaders().stream().filter(header -> !X_MS_VERSION.equalsIgnoreCase(header.getName())).forEach(header -> BlobBatchOperationInfo.appendWithNewline(batchRequestBuilder, String.format(HEADER_TEMPLATE, header.getName(), header.getValue())));
        batchRequestBuilder.append("\r\n");
        this.batchOperationResponseMap.put(contentId, batchOperation.setRequest(request));
        this.batchOperations.add(ByteBuffer.wrap(batchRequestBuilder.toString().getBytes(StandardCharsets.UTF_8)));
    }

    void finalizeBatchOperations() {
        this.batchOperations.add(ByteBuffer.wrap(String.format("--%s--%s", this.batchBoundary, "\r\n").getBytes(StandardCharsets.UTF_8)));
    }

    BlobBatchOperationResponse<?> getBatchRequest(int contentId) {
        return this.batchOperationResponseMap.get(contentId);
    }

    int getOperationCount() {
        return this.batchOperationResponseMap.size();
    }

    private static void appendWithNewline(StringBuilder stringBuilder, String value) {
        stringBuilder.append(value).append("\r\n");
    }
}

