/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.batch;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.CoreUtils;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceAsyncClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.batch.BlobBatchAsyncClient;
import com.azure.storage.blob.batch.BlobBatchClient;
import com.azure.storage.blob.implementation.util.BlobUserAgentModificationPolicy;
import java.util.ArrayList;
import java.util.Map;

@ServiceClientBuilder(serviceClients={BlobBatchClient.class, BlobBatchAsyncClient.class})
public final class BlobBatchClientBuilder {
    private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-storage-blob-batch.properties");
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private static final String CLIENT_NAME = PROPERTIES.getOrDefault("name", "UnknownName");
    private static final String CLIENT_VERSION = PROPERTIES.getOrDefault("version", "UnknownVersion");
    private final String clientUrl;
    private final HttpPipeline pipeline;
    private final BlobServiceVersion version;
    private final boolean containerScoped;

    public BlobBatchClientBuilder(BlobServiceClient client) {
        this.clientUrl = client.getAccountUrl();
        this.pipeline = client.getHttpPipeline();
        this.version = client.getServiceVersion();
        this.containerScoped = false;
    }

    public BlobBatchClientBuilder(BlobServiceAsyncClient client) {
        this.clientUrl = client.getAccountUrl();
        this.pipeline = client.getHttpPipeline();
        this.version = client.getServiceVersion();
        this.containerScoped = false;
    }

    public BlobBatchClientBuilder(BlobContainerClient client) {
        this.clientUrl = client.getBlobContainerUrl();
        this.pipeline = client.getHttpPipeline();
        this.version = client.getServiceVersion();
        this.containerScoped = true;
    }

    public BlobBatchClientBuilder(BlobContainerAsyncClient client) {
        this.clientUrl = client.getBlobContainerUrl();
        this.pipeline = client.getHttpPipeline();
        this.version = client.getServiceVersion();
        this.containerScoped = true;
    }

    public BlobBatchClient buildClient() {
        return new BlobBatchClient(this.buildAsyncClient());
    }

    public BlobBatchAsyncClient buildAsyncClient() {
        BlobServiceVersion serviceVersion = this.version != null ? this.version : BlobServiceVersion.getLatest();
        return new BlobBatchAsyncClient(this.clientUrl, this.addBlobUserAgentModificationPolicy(this.pipeline), serviceVersion, this.containerScoped);
    }

    private HttpPipeline addBlobUserAgentModificationPolicy(HttpPipeline pipeline) {
        ArrayList<Object> policies = new ArrayList<Object>();
        for (int i = 0; i < pipeline.getPolicyCount(); ++i) {
            HttpPipelinePolicy currPolicy = pipeline.getPolicy(i);
            policies.add(currPolicy);
            if (!(currPolicy instanceof UserAgentPolicy)) continue;
            policies.add(new BlobUserAgentModificationPolicy(CLIENT_NAME, CLIENT_VERSION));
        }
        return new HttpPipelineBuilder().httpClient(pipeline.getHttpClient()).policies(policies.toArray(new HttpPipelinePolicy[0])).tracer(pipeline.getTracer()).build();
    }
}

