/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.changefeed;

import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.changefeed.ChunkFactory;
import com.azure.storage.blob.changefeed.implementation.models.BlobChangefeedEventWrapper;
import com.azure.storage.blob.changefeed.implementation.models.ChangefeedCursor;
import com.azure.storage.blob.changefeed.implementation.models.ShardCursor;
import com.azure.storage.blob.models.ListBlobsOptions;
import java.util.concurrent.atomic.AtomicBoolean;
import reactor.core.publisher.Flux;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

class Shard {
    private final BlobContainerAsyncClient client;
    private final String shardPath;
    private final ChangefeedCursor changefeedCursor;
    private final ShardCursor userCursor;
    private final ChunkFactory chunkFactory;

    Shard(BlobContainerAsyncClient client, String shardPath, ChangefeedCursor changefeedCursor, ShardCursor userCursor, ChunkFactory chunkFactory) {
        this.client = client;
        this.shardPath = shardPath;
        this.changefeedCursor = changefeedCursor;
        this.userCursor = userCursor;
        this.chunkFactory = chunkFactory;
    }

    Flux<BlobChangefeedEventWrapper> getEvents() {
        return this.listChunks().concatMap(tuple2 -> {
            long blockOffset = 0L;
            long eventIndex = 0L;
            if (this.userCursor != null && this.userCursor.getCurrentChunkPath().equals(tuple2.getT1())) {
                blockOffset = this.userCursor.getBlockOffset();
                eventIndex = this.userCursor.getEventIndex();
            }
            return this.chunkFactory.getChunk((String)tuple2.getT1(), (Long)tuple2.getT2(), this.changefeedCursor, blockOffset, eventIndex).getEvents();
        });
    }

    private Flux<Tuple2<String, Long>> listChunks() {
        Flux chunks = this.client.listBlobs(new ListBlobsOptions().setPrefix(this.shardPath)).map(blobItem -> Tuples.of((Object)blobItem.getName(), (Object)blobItem.getProperties().getContentLength()));
        if (this.userCursor == null) {
            return chunks;
        }
        return Flux.defer(() -> {
            AtomicBoolean pass = new AtomicBoolean();
            return chunks.filter(tuple2 -> {
                if (pass.get()) {
                    return true;
                }
                if (this.userCursor.getCurrentChunkPath().equals(tuple2.getT1())) {
                    pass.set(true);
                    return true;
                }
                return false;
            });
        });
    }
}

