/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.changefeed.implementation.util;

import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import reactor.core.publisher.Mono;

public class DownloadUtils {
    private static final ClientLogger LOGGER = new ClientLogger(DownloadUtils.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static Mono<byte[]> downloadToByteArray(BlobContainerAsyncClient client, String blobPath) {
        return client.getBlobAsyncClient(blobPath).download().reduce((Object)new ByteArrayOutputStream(), (os, buffer) -> {
            try {
                os.write(FluxUtil.byteBufferToArray((ByteBuffer)buffer));
            }
            catch (IOException e) {
                throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
            }
            return os;
        }).map(ByteArrayOutputStream::toByteArray);
    }

    public static Mono<JsonNode> parseJson(byte[] json) {
        try {
            JsonNode jsonNode = MAPPER.reader().readTree(json);
            return Mono.just((Object)jsonNode);
        }
        catch (IOException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new UncheckedIOException(e));
        }
    }
}

