/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.changefeed;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.util.Context;
import com.azure.storage.blob.changefeed.BlobChangefeedAsyncClient;
import com.azure.storage.blob.changefeed.BlobChangefeedClientBuilder;
import com.azure.storage.blob.changefeed.BlobChangefeedPagedIterable;
import java.time.OffsetDateTime;

@ServiceClient(builder=BlobChangefeedClientBuilder.class)
public class BlobChangefeedClient {
    private final BlobChangefeedAsyncClient client;

    BlobChangefeedClient(BlobChangefeedAsyncClient client) {
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public BlobChangefeedPagedIterable getEvents() {
        return this.getEvents((OffsetDateTime)null, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public BlobChangefeedPagedIterable getEvents(OffsetDateTime startTime, OffsetDateTime endTime) {
        return this.getEvents(startTime, endTime, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public BlobChangefeedPagedIterable getEvents(OffsetDateTime startTime, OffsetDateTime endTime, Context context) {
        return new BlobChangefeedPagedIterable(this.client.getEvents(startTime, endTime).setSubscriberContext(context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public BlobChangefeedPagedIterable getEvents(String cursor) {
        return this.getEvents(cursor, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public BlobChangefeedPagedIterable getEvents(String cursor, Context context) {
        return new BlobChangefeedPagedIterable(this.client.getEvents(cursor).setSubscriberContext(context));
    }
}

