/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.changefeed;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.changefeed.BlobChunkedDownloaderFactory;
import com.azure.storage.blob.changefeed.Chunk;
import com.azure.storage.blob.changefeed.implementation.models.ChangefeedCursor;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.internal.avro.implementation.AvroReader;
import com.azure.storage.internal.avro.implementation.AvroReaderFactory;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;

class ChunkFactory {
    private static final ClientLogger LOGGER = new ClientLogger(ChunkFactory.class);
    private static final long DEFAULT_HEADER_SIZE = 4096L;
    private static final long DEFAULT_BODY_SIZE = 0x100000L;
    private final AvroReaderFactory avroReaderFactory;
    private final BlobChunkedDownloaderFactory blobChunkedDownloaderFactory;

    ChunkFactory(AvroReaderFactory avroReaderFactory, BlobChunkedDownloaderFactory blobChunkedDownloaderFactory) {
        StorageImplUtils.assertNotNull((String)"avroReaderFactory", (Object)avroReaderFactory);
        StorageImplUtils.assertNotNull((String)"blobLazyDownloaderFactory", (Object)blobChunkedDownloaderFactory);
        this.avroReaderFactory = avroReaderFactory;
        this.blobChunkedDownloaderFactory = blobChunkedDownloaderFactory;
    }

    Chunk getChunk(String chunkPath, long chunkLength, ChangefeedCursor changefeedCursor, long blockOffset, long eventIndex) {
        AvroReader avroReader;
        StorageImplUtils.assertNotNull((String)"chunkPath", (Object)chunkPath);
        StorageImplUtils.assertNotNull((String)"chunkLength", (Object)chunkLength);
        StorageImplUtils.assertNotNull((String)"changefeedCursor", (Object)changefeedCursor);
        StorageImplUtils.assertInBounds((String)"blockOffset", (long)blockOffset, (long)0L, (long)Long.MAX_VALUE);
        StorageImplUtils.assertInBounds((String)"eventIndex", (long)eventIndex, (long)0L, (long)Long.MAX_VALUE);
        if (blockOffset == 0L) {
            Flux<ByteBuffer> avro = this.blobChunkedDownloaderFactory.getBlobLazyDownloader(chunkPath, 0x100000L, blockOffset).download();
            avroReader = this.avroReaderFactory.getAvroReader(avro);
        } else if (chunkLength > blockOffset) {
            Flux<ByteBuffer> avroHeader = this.blobChunkedDownloaderFactory.getBlobLazyDownloader(chunkPath, 4096L).download();
            Flux<ByteBuffer> avroBody = this.blobChunkedDownloaderFactory.getBlobLazyDownloader(chunkPath, 0x100000L, blockOffset).download();
            avroReader = this.avroReaderFactory.getAvroReader(avroHeader, avroBody, blockOffset, eventIndex);
        } else if (chunkLength == blockOffset) {
            avroReader = Flux::empty;
        } else {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Cursor contains a blockOffset that is invalid."));
        }
        return new Chunk(chunkPath, changefeedCursor, avroReader);
    }
}

