/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.changefeed;

import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.changefeed.ChunkFactory;
import com.azure.storage.blob.changefeed.Shard;
import com.azure.storage.blob.changefeed.implementation.models.ChangefeedCursor;
import com.azure.storage.blob.changefeed.implementation.models.ShardCursor;
import com.azure.storage.common.implementation.StorageImplUtils;

class ShardFactory {
    private final ChunkFactory chunkFactory;
    private final BlobContainerAsyncClient client;

    ShardFactory(ChunkFactory chunkFactory, BlobContainerAsyncClient client) {
        StorageImplUtils.assertNotNull((String)"chunkFactory", (Object)chunkFactory);
        StorageImplUtils.assertNotNull((String)"client", (Object)client);
        this.chunkFactory = chunkFactory;
        this.client = client;
    }

    Shard getShard(String shardPath, ChangefeedCursor changefeedCursor, ShardCursor userCursor) {
        StorageImplUtils.assertNotNull((String)"shardPath", (Object)shardPath);
        StorageImplUtils.assertNotNull((String)"changefeedCursor", (Object)changefeedCursor);
        return new Shard(this.client, shardPath, changefeedCursor, userCursor, this.chunkFactory);
    }
}

