/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.changefeed.implementation.util;

import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;

public class TimeUtils {
    public static OffsetDateTime convertPathToTime(String path) {
        if (path == null) {
            return null;
        }
        String[] splitPath = path.split("/");
        return OffsetDateTime.of(Integer.parseInt(splitPath[2]), splitPath.length < 4 ? 1 : Integer.parseInt(splitPath[3]), splitPath.length < 5 ? 1 : Integer.parseInt(splitPath[4]), splitPath.length < 6 ? 0 : Integer.parseInt(splitPath[5]) / 100, 0, 0, 0, ZoneOffset.UTC);
    }

    public static boolean validYear(String year, OffsetDateTime start, OffsetDateTime end) {
        if (year == null || start == null || end == null) {
            return false;
        }
        OffsetDateTime currentYear = TimeUtils.convertPathToTime(year);
        OffsetDateTime startYear = TimeUtils.roundDownToNearestYear(start);
        OffsetDateTime endYear = TimeUtils.roundDownToNearestYear(end);
        return !(!currentYear.isEqual(startYear) && !currentYear.isAfter(startYear) || !currentYear.isEqual(endYear) && !currentYear.isBefore(endYear));
    }

    public static boolean validSegment(String segment, OffsetDateTime start, OffsetDateTime end) {
        if (segment == null || start == null || end == null) {
            return false;
        }
        OffsetDateTime hour = TimeUtils.convertPathToTime(segment);
        OffsetDateTime startHour = TimeUtils.roundDownToNearestHour(start);
        OffsetDateTime endHour = TimeUtils.roundUpToNearestHour(end);
        return (hour.isEqual(startHour) || hour.isAfter(startHour)) && hour.isBefore(endHour);
    }

    public static OffsetDateTime roundUpToNearestHour(OffsetDateTime time) {
        if (time == null) {
            return null;
        }
        if (time.equals(OffsetDateTime.MIN) || time.equals(OffsetDateTime.MAX)) {
            return time;
        }
        if (time.equals(time.truncatedTo(ChronoUnit.HOURS))) {
            return time;
        }
        return time.truncatedTo(ChronoUnit.HOURS).plusHours(1L);
    }

    public static OffsetDateTime roundDownToNearestHour(OffsetDateTime time) {
        if (time == null) {
            return null;
        }
        if (time.equals(OffsetDateTime.MIN) || time.equals(OffsetDateTime.MAX)) {
            return time;
        }
        return time.truncatedTo(ChronoUnit.HOURS);
    }

    private static OffsetDateTime roundDownToNearestYear(OffsetDateTime time) {
        if (time == null) {
            return null;
        }
        return OffsetDateTime.of(time.getYear(), 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
    }
}

