/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.changefeed.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.changefeed.implementation.models.SegmentCursor;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.OffsetDateTime;
import java.util.Objects;

public class ChangefeedCursor {
    private static final ClientLogger LOGGER = new ClientLogger(ChangefeedCursor.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE).registerModule((Module)new JavaTimeModule());
    @JsonProperty(value="CursorVersion")
    private int cursorVersion;
    @JsonProperty(value="UrlHost")
    private String urlHost;
    @JsonProperty(value="EndTime")
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private OffsetDateTime endTime;
    @JsonProperty(value="CurrentSegmentCursor")
    private SegmentCursor currentSegmentCursor;

    public ChangefeedCursor() {
    }

    public ChangefeedCursor(int cursorVersion, String urlHost, OffsetDateTime endTime, SegmentCursor currentSegmentCursor) {
        this.cursorVersion = cursorVersion;
        this.urlHost = urlHost;
        this.endTime = endTime;
        this.currentSegmentCursor = currentSegmentCursor;
    }

    public ChangefeedCursor(String urlHost, OffsetDateTime endTime) {
        this(1, urlHost, endTime, null);
    }

    public ChangefeedCursor toSegmentCursor(String segmentPath, SegmentCursor userSegmentCursor) {
        return new ChangefeedCursor(this.cursorVersion, this.urlHost, this.endTime, new SegmentCursor(segmentPath, userSegmentCursor));
    }

    public ChangefeedCursor toShardCursor(String shardPath) {
        return new ChangefeedCursor(this.cursorVersion, this.urlHost, this.endTime, this.currentSegmentCursor.toShardCursor(shardPath));
    }

    public ChangefeedCursor toEventCursor(String chunkPath, long blockOffset, long eventIndex) {
        return new ChangefeedCursor(this.cursorVersion, this.urlHost, this.endTime, this.currentSegmentCursor.toEventCursor(chunkPath, blockOffset, eventIndex));
    }

    public int getCursorVersion() {
        return this.cursorVersion;
    }

    public String getUrlHost() {
        return this.urlHost;
    }

    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public SegmentCursor getCurrentSegmentCursor() {
        return this.currentSegmentCursor;
    }

    public ChangefeedCursor setCursorVersion(int cursorVersion) {
        this.cursorVersion = cursorVersion;
        return this;
    }

    public ChangefeedCursor setUrlHost(String urlHost) {
        this.urlHost = urlHost;
        return this;
    }

    public ChangefeedCursor setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public ChangefeedCursor setCurrentSegmentCursor(SegmentCursor currentSegmentCursor) {
        this.currentSegmentCursor = currentSegmentCursor;
        return this;
    }

    public String serialize() {
        try {
            return MAPPER.writer().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException((IOException)((Object)e)));
        }
    }

    public static ChangefeedCursor deserialize(String cursor, ClientLogger logger) {
        try {
            return (ChangefeedCursor)MAPPER.readerFor(ChangefeedCursor.class).readValue(cursor);
        }
        catch (IOException e) {
            throw logger.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangefeedCursor)) {
            return false;
        }
        ChangefeedCursor cursor = (ChangefeedCursor)o;
        return this.getCursorVersion() == cursor.getCursorVersion() && Objects.equals(this.getUrlHost(), cursor.getUrlHost()) && Objects.equals(this.getEndTime(), cursor.getEndTime()) && Objects.equals(this.getCurrentSegmentCursor(), cursor.getCurrentSegmentCursor());
    }

    public int hashCode() {
        return Objects.hash(this.getCursorVersion(), this.getUrlHost(), this.getEndTime(), this.getCurrentSegmentCursor());
    }
}

